/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable.BudgetAccountCoreHierNodeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNode
 * BudgetAccountCoreHierNode} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BudgetAccountCoreHierNodeByKeyFluentHelper
    extends
    FluentHelperByKey<BudgetAccountCoreHierNodeByKeyFluentHelper, BudgetAccountCoreHierNode, BudgetAccountCoreHierNodeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNode
     * BudgetAccountCoreHierNode} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BudgetAccountCoreHierNode}
     * @param budgetAccountHierarchy
     *            Budget Account Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BudgetAccountCoreHierNode}
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public BudgetAccountCoreHierNodeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String budgetAccountHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("BudgetAccountHierarchy", budgetAccountHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
    }

    @Override
    @Nonnull
    protected Class<BudgetAccountCoreHierNode> getEntityClass()
    {
        return BudgetAccountCoreHierNode.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
