/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.field.BudgetAccountCoreHierarchyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.link.BudgetAccountCoreHierarchyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable.BudgetAccountCoreHierarchySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Account Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetAccountCoreHierarchy_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetAccountCoreHierarchy extends VdmEntity<BudgetAccountCoreHierarchy>
{

    /**
     * Selector for all available fields of BudgetAccountCoreHierarchy.
     *
     */
    public final static BudgetAccountCoreHierarchySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchy</b>
     * </p>
     *
     * @return Budget Account Hierarchy
     */
    @Key
    @SerializedName( "BudgetAccountHierarchy" )
    @JsonProperty( "BudgetAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "BudgetAccountHierarchy" )
    private String budgetAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>BudgetAccountHierarchy</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyField<String> BUDGET_ACCOUNT_HIERARCHY =
        new BudgetAccountCoreHierarchyField<String>("BudgetAccountHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyField<LocalDateTime> VALIDITY_END_DATE =
        new BudgetAccountCoreHierarchyField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyField<LocalDateTime> VALIDITY_START_DATE =
        new BudgetAccountCoreHierarchyField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyField<String> CHART_OF_ACCOUNTS =
        new BudgetAccountCoreHierarchyField<String>("ChartOfAccounts");
    /**
     * Navigation property <b>to_BudgetAccountCoreHierNode</b> for <b>BudgetAccountCoreHierarchy</b> to multiple
     * <b>BudgetAccountCoreHierNode</b>.
     *
     */
    @SerializedName( "to_BudgetAccountCoreHierNode" )
    @JsonProperty( "to_BudgetAccountCoreHierNode" )
    @ODataField( odataName = "to_BudgetAccountCoreHierNode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetAccountCoreHierNode> toBudgetAccountCoreHierNode;
    /**
     * Navigation property <b>to_Text</b> for <b>BudgetAccountCoreHierarchy</b> to multiple
     * <b>BudgetAccountCoreHierarchyText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetAccountCoreHierarchyText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_BudgetAccountCoreHierNode</b> navigation property to query
     * operations.
     *
     */
    public final static BudgetAccountCoreHierarchyLink<BudgetAccountCoreHierNode> TO_BUDGET_ACCOUNT_CORE_HIER_NODE =
        new BudgetAccountCoreHierarchyLink<BudgetAccountCoreHierNode>("to_BudgetAccountCoreHierNode");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyLink<BudgetAccountCoreHierarchyText> TO_TEXT =
        new BudgetAccountCoreHierarchyLink<BudgetAccountCoreHierarchyText>("to_Text");

    @Nonnull
    @Override
    public Class<BudgetAccountCoreHierarchy> getType()
    {
        return BudgetAccountCoreHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchy</b>
     * </p>
     *
     * @param budgetAccountHierarchy
     *            Budget Account Hierarchy
     */
    public void setBudgetAccountHierarchy( @Nullable final String budgetAccountHierarchy )
    {
        rememberChangedField("BudgetAccountHierarchy", this.budgetAccountHierarchy);
        this.budgetAccountHierarchy = budgetAccountHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetAccountHierarchy";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BudgetAccountHierarchy", getBudgetAccountHierarchy());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BudgetAccountHierarchy", getBudgetAccountHierarchy());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ChartOfAccounts", getChartOfAccounts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BudgetAccountHierarchy") ) {
                final Object value = values.remove("BudgetAccountHierarchy");
                if( (value == null) || (!value.equals(getBudgetAccountHierarchy())) ) {
                    setBudgetAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BudgetAccountCoreHierNode") ) {
                final Object value = (values).remove("to_BudgetAccountCoreHierNode");
                if( value instanceof Iterable ) {
                    if( toBudgetAccountCoreHierNode == null ) {
                        toBudgetAccountCoreHierNode = Lists.newArrayList();
                    } else {
                        toBudgetAccountCoreHierNode = Lists.newArrayList(toBudgetAccountCoreHierNode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetAccountCoreHierNode entity;
                        if( toBudgetAccountCoreHierNode.size() > i ) {
                            entity = toBudgetAccountCoreHierNode.get(i);
                        } else {
                            entity = new BudgetAccountCoreHierNode();
                            toBudgetAccountCoreHierNode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetAccountCoreHierarchyText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BudgetAccountCoreHierarchyText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BudgetAccountCoreHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BudgetAccountCoreHierarchyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetAccountCoreHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetAccountCoreHierarchyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBudgetAccountCoreHierNode != null ) {
            (values).put("to_BudgetAccountCoreHierNode", toBudgetAccountCoreHierNode);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetAccountCoreHierNode</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BudgetAccountCoreHierNode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetAccountCoreHierNode</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreHierNode> fetchBudgetAccountCoreHierNode()
    {
        return fetchFieldAsList("to_BudgetAccountCoreHierNode", BudgetAccountCoreHierNode.class);
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreHierNode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BudgetAccountCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetAccountCoreHierNode</b> of a queried <b>BudgetAccountCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetAccountCoreHierNode</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreHierNode> getBudgetAccountCoreHierNodeOrFetch()
    {
        if( toBudgetAccountCoreHierNode == null ) {
            toBudgetAccountCoreHierNode = fetchBudgetAccountCoreHierNode();
        }
        return toBudgetAccountCoreHierNode;
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreHierNode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BudgetAccountCoreHierNode</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetAccountCoreHierarchy</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BudgetAccountCoreHierNode</b> is already loaded, the
     *         result will contain the <b>BudgetAccountCoreHierNode</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BudgetAccountCoreHierNode>> getBudgetAccountCoreHierNodeIfPresent()
    {
        return Option.of(toBudgetAccountCoreHierNode);
    }

    /**
     * Overwrites the list of associated <b>BudgetAccountCoreHierNode</b> entities for the loaded navigation property
     * <b>to_BudgetAccountCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetAccountCoreHierNode</b> of a queried <b>BudgetAccountCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetAccountCoreHierNode</b> entities.
     */
    public void setBudgetAccountCoreHierNode( @Nonnull final List<BudgetAccountCoreHierNode> value )
    {
        if( toBudgetAccountCoreHierNode == null ) {
            toBudgetAccountCoreHierNode = Lists.newArrayList();
        }
        toBudgetAccountCoreHierNode.clear();
        toBudgetAccountCoreHierNode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetAccountCoreHierNode</b> entities. This corresponds to the OData
     * navigation property <b>to_BudgetAccountCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetAccountCoreHierNode</b> of a queried <b>BudgetAccountCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetAccountCoreHierNode</b> entities.
     */
    public void addBudgetAccountCoreHierNode( BudgetAccountCoreHierNode... entity )
    {
        if( toBudgetAccountCoreHierNode == null ) {
            toBudgetAccountCoreHierNode = Lists.newArrayList();
        }
        toBudgetAccountCoreHierNode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BudgetAccountCoreHierarchyText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetAccountCoreHierarchyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreHierarchyText> fetchText()
    {
        return fetchFieldAsList("to_Text", BudgetAccountCoreHierarchyText.class);
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreHierarchyText</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetAccountCoreHierarchyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetAccountCoreHierarchyText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BudgetAccountCoreHierarchyText</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetAccountCoreHierarchy</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BudgetAccountCoreHierarchyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BudgetAccountCoreHierarchyText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BudgetAccountCoreHierarchyText</b> entities for the loaded navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetAccountCoreHierarchyText</b> entities.
     */
    public void setText( @Nonnull final List<BudgetAccountCoreHierarchyText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetAccountCoreHierarchyText</b> entities. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetAccountCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetAccountCoreHierarchyText</b> entities.
     */
    public void addText( BudgetAccountCoreHierarchyText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BudgetAccountCoreHierarchy instances.
     *
     */
    public final static class BudgetAccountCoreHierarchyBuilder
    {

        private List<BudgetAccountCoreHierNode> toBudgetAccountCoreHierNode = Lists.newArrayList();
        private List<BudgetAccountCoreHierarchyText> toText = Lists.newArrayList();

        private BudgetAccountCoreHierarchy.BudgetAccountCoreHierarchyBuilder toBudgetAccountCoreHierNode(
            final List<BudgetAccountCoreHierNode> value )
        {
            toBudgetAccountCoreHierNode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BudgetAccountCoreHierNode</b> for <b>BudgetAccountCoreHierarchy</b> to multiple
         * <b>BudgetAccountCoreHierNode</b>.
         *
         * @param value
         *            The BudgetAccountCoreHierNodes to build this BudgetAccountCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetAccountCoreHierarchy.BudgetAccountCoreHierarchyBuilder budgetAccountCoreHierNode(
            BudgetAccountCoreHierNode... value )
        {
            return toBudgetAccountCoreHierNode(Lists.newArrayList(value));
        }

        private BudgetAccountCoreHierarchy.BudgetAccountCoreHierarchyBuilder toText(
            final List<BudgetAccountCoreHierarchyText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BudgetAccountCoreHierarchy</b> to multiple
         * <b>BudgetAccountCoreHierarchyText</b>.
         *
         * @param value
         *            The BudgetAccountCoreHierarchyTexts to build this BudgetAccountCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetAccountCoreHierarchy.BudgetAccountCoreHierarchyBuilder text(
            BudgetAccountCoreHierarchyText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
