/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.field.BudgetAccountCoreHierarchyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable.BudgetAccountCoreHierarchyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Budget Account Hierarchy Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BudgetAccountCoreHierarchyText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetAccountCoreHierarchyText extends VdmEntity<BudgetAccountCoreHierarchyText>
{

    /**
     * Selector for all available fields of BudgetAccountCoreHierarchyText.
     *
     */
    public final static BudgetAccountCoreHierarchyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchy</b>
     * </p>
     *
     * @return Budget Account Hierarchy
     */
    @Key
    @SerializedName( "BudgetAccountHierarchy" )
    @JsonProperty( "BudgetAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "BudgetAccountHierarchy" )
    private String budgetAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>BudgetAccountHierarchy</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyTextField<String> BUDGET_ACCOUNT_HIERARCHY =
        new BudgetAccountCoreHierarchyTextField<String>("BudgetAccountHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyTextField<LocalDateTime> VALIDITY_END_DATE =
        new BudgetAccountCoreHierarchyTextField<LocalDateTime>("ValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyTextField<String> LANGUAGE =
        new BudgetAccountCoreHierarchyTextField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyTextField<LocalDateTime> VALIDITY_START_DATE =
        new BudgetAccountCoreHierarchyTextField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchyName</b>
     * </p>
     *
     * @return Hierarchy description
     */
    @SerializedName( "BudgetAccountHierarchyName" )
    @JsonProperty( "BudgetAccountHierarchyName" )
    @Nullable
    @ODataField( odataName = "BudgetAccountHierarchyName" )
    private String budgetAccountHierarchyName;
    /**
     * Use with available fluent helpers to apply the <b>BudgetAccountHierarchyName</b> field to query operations.
     *
     */
    public final static BudgetAccountCoreHierarchyTextField<String> BUDGET_ACCOUNT_HIERARCHY_NAME =
        new BudgetAccountCoreHierarchyTextField<String>("BudgetAccountHierarchyName");

    @Nonnull
    @Override
    public Class<BudgetAccountCoreHierarchyText> getType()
    {
        return BudgetAccountCoreHierarchyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchy</b>
     * </p>
     *
     * @param budgetAccountHierarchy
     *            Budget Account Hierarchy
     */
    public void setBudgetAccountHierarchy( @Nullable final String budgetAccountHierarchy )
    {
        rememberChangedField("BudgetAccountHierarchy", this.budgetAccountHierarchy);
        this.budgetAccountHierarchy = budgetAccountHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BudgetAccountHierarchyName</b>
     * </p>
     *
     * @param budgetAccountHierarchyName
     *            Hierarchy description
     */
    public void setBudgetAccountHierarchyName( @Nullable final String budgetAccountHierarchyName )
    {
        rememberChangedField("BudgetAccountHierarchyName", this.budgetAccountHierarchyName);
        this.budgetAccountHierarchyName = budgetAccountHierarchyName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetAccountHierarchyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BudgetAccountHierarchy", getBudgetAccountHierarchy());
        result.put("ValidityEndDate", getValidityEndDate());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BudgetAccountHierarchy", getBudgetAccountHierarchy());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("Language", getLanguage());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("BudgetAccountHierarchyName", getBudgetAccountHierarchyName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BudgetAccountHierarchy") ) {
                final Object value = values.remove("BudgetAccountHierarchy");
                if( (value == null) || (!value.equals(getBudgetAccountHierarchy())) ) {
                    setBudgetAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BudgetAccountHierarchyName") ) {
                final Object value = values.remove("BudgetAccountHierarchyName");
                if( (value == null) || (!value.equals(getBudgetAccountHierarchyName())) ) {
                    setBudgetAccountHierarchyName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BudgetAccountCoreHierarchyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BudgetAccountCoreHierarchyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetAccountCoreHierarchyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetAccountCoreHierarchyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService.DEFAULT_SERVICE_PATH);
    }

}
