/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable.BudgetAccountCoreHierarchyTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText
 * BudgetAccountCoreHierarchyText} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class BudgetAccountCoreHierarchyTextByKeyFluentHelper
    extends
    FluentHelperByKey<BudgetAccountCoreHierarchyTextByKeyFluentHelper, BudgetAccountCoreHierarchyText, BudgetAccountCoreHierarchyTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText
     * BudgetAccountCoreHierarchyText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BudgetAccountCoreHierarchyText}
     * @param budgetAccountHierarchy
     *            Budget Account Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BudgetAccountCoreHierarchyText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     */
    public BudgetAccountCoreHierarchyTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String budgetAccountHierarchy,
        final LocalDateTime validityEndDate,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("BudgetAccountHierarchy", budgetAccountHierarchy);
        this.key.put("ValidityEndDate", validityEndDate);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<BudgetAccountCoreHierarchyText> getEntityClass()
    {
        return BudgetAccountCoreHierarchyText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
