/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BudgetAccountHierarchyServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService
 * BudgetAccountHierarchyService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBudgetAccountHierarchyServiceBatch
    extends
    BatchFluentHelperBasic<BudgetAccountHierarchyServiceBatch, BudgetAccountHierarchyServiceBatchChangeSet>
    implements
    BudgetAccountHierarchyServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBudgetAccountHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetAccountHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBudgetAccountHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetAccountHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetAccountHierarchyService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBudgetAccountHierarchyServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BudgetAccountHierarchyServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBudgetAccountHierarchyServiceBatchChangeSet(this, service);
    }

}
