/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNode;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable.BudgetAccountCoreHierNodeSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNode
 * BudgetAccountCoreHierNode} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BudgetAccountCoreHierNodeLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BudgetAccountCoreHierNodeLink<ObjectT>, BudgetAccountCoreHierNode, ObjectT>
    implements
    BudgetAccountCoreHierNodeSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BudgetAccountCoreHierNodeLink( final String fieldName )
    {
        super(fieldName);
    }

    private BudgetAccountCoreHierNodeLink(
        final EntityLink<BudgetAccountCoreHierNodeLink<ObjectT>, BudgetAccountCoreHierNode, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BudgetAccountCoreHierNodeLink<ObjectT> translateLinkType(
        final EntityLink<BudgetAccountCoreHierNodeLink<ObjectT>, BudgetAccountCoreHierNode, ObjectT> link )
    {
        return new BudgetAccountCoreHierNodeLink<ObjectT>(link);
    }

}
