/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText
 * BudgetAccountCoreHierarchyText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.field.BudgetAccountCoreHierarchyTextField
 * BudgetAccountCoreHierarchyTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.link.BudgetAccountCoreHierarchyTextLink
 * BudgetAccountCoreHierarchyTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText#BUDGET_ACCOUNT_HIERARCHY
 * BUDGET_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyText#BUDGET_ACCOUNT_HIERARCHY_NAME
 * BUDGET_ACCOUNT_HIERARCHY_NAME}</li>
 * </ul>
 *
 */
public interface BudgetAccountCoreHierarchyTextSelectable extends EntitySelectable<BudgetAccountCoreHierarchyText>
{

}
