/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText
 * BudgetPeriodCoreHierarchyNodeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.field.BudgetPeriodCoreHierarchyNodeTextField
 * BudgetPeriodCoreHierarchyNodeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.link.BudgetPeriodCoreHierarchyNodeTextLink
 * BudgetPeriodCoreHierarchyNodeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#BUDGET_ACCOUNT_HIERARCHY
 * BUDGET_ACCOUNT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#HIERARCHY_NODE_TEXT
 * HIERARCHY_NODE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#HIERARCHY_NODE_SHORT_TEXT
 * HIERARCHY_NODE_SHORT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * </ul>
 *
 */
public interface BudgetPeriodCoreHierarchyNodeTextSelectable extends EntitySelectable<BudgetPeriodCoreHierarchyNodeText>
{

}
