/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.field.BudgetPeriodField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.link.BudgetPeriodLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.selectable.BudgetPeriodSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Period
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetPeriod_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetPeriod extends VdmEntity<BudgetPeriod>
{

    /**
     * Selector for all available fields of BudgetPeriod.
     *
     */
    public final static BudgetPeriodSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @Key
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD = new BudgetPeriodField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Budget Period Valid From
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<LocalDateTime> VALIDITY_START_DATE =
        new BudgetPeriodField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Budget Period Valid To
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<LocalDateTime> VALIDITY_END_DATE =
        new BudgetPeriodField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodExpirationDate</b>
     * </p>
     *
     * @return Budget Period Expiration Date
     */
    @SerializedName( "BudgetPeriodExpirationDate" )
    @JsonProperty( "BudgetPeriodExpirationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BudgetPeriodExpirationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime budgetPeriodExpirationDate;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodExpirationDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<LocalDateTime> BUDGET_PERIOD_EXPIRATION_DATE =
        new BudgetPeriodField<LocalDateTime>("BudgetPeriodExpirationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodReversalDate</b>
     * </p>
     *
     * @return Budget Period Reversal Date
     */
    @SerializedName( "BudgetPeriodReversalDate" )
    @JsonProperty( "BudgetPeriodReversalDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BudgetPeriodReversalDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime budgetPeriodReversalDate;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodReversalDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<LocalDateTime> BUDGET_PERIOD_REVERSAL_DATE =
        new BudgetPeriodField<LocalDateTime>("BudgetPeriodReversalDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodAuthznGrp</b>
     * </p>
     *
     * @return Budget Period Authorization Group
     */
    @SerializedName( "BudgetPeriodAuthznGrp" )
    @JsonProperty( "BudgetPeriodAuthznGrp" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodAuthznGrp" )
    private String budgetPeriodAuthznGrp;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodAuthznGrp</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD_AUTHZN_GRP =
        new BudgetPeriodField<String>("BudgetPeriodAuthznGrp");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodPeriodicity</b>
     * </p>
     *
     * @return Frequency for Budget Period
     */
    @SerializedName( "BudgetPeriodPeriodicity" )
    @JsonProperty( "BudgetPeriodPeriodicity" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodPeriodicity" )
    private String budgetPeriodPeriodicity;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodPeriodicity</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD_PERIODICITY =
        new BudgetPeriodField<String>("BudgetPeriodPeriodicity");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodName</b>
     * </p>
     *
     * @return Budget Period Name
     */
    @SerializedName( "BudgetPeriodName" )
    @JsonProperty( "BudgetPeriodName" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodName" )
    private String budgetPeriodName;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodName</b> field to query operations.
     *
     */
    public final static BudgetPeriodField<String> BUDGET_PERIOD_NAME =
        new BudgetPeriodField<String>("BudgetPeriodName");
    /**
     * Navigation property <b>to_Text</b> for <b>BudgetPeriod</b> to multiple <b>BudgetPeriodCoreText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetPeriodCoreText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BudgetPeriodLink<BudgetPeriodCoreText> TO_TEXT =
        new BudgetPeriodLink<BudgetPeriodCoreText>("to_Text");

    @Nonnull
    @Override
    public Class<BudgetPeriod> getType()
    {
        return BudgetPeriod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Budget Period Valid From
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Budget Period Valid To
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodExpirationDate</b>
     * </p>
     *
     * @param budgetPeriodExpirationDate
     *            Budget Period Expiration Date
     */
    public void setBudgetPeriodExpirationDate( @Nullable final LocalDateTime budgetPeriodExpirationDate )
    {
        rememberChangedField("BudgetPeriodExpirationDate", this.budgetPeriodExpirationDate);
        this.budgetPeriodExpirationDate = budgetPeriodExpirationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodReversalDate</b>
     * </p>
     *
     * @param budgetPeriodReversalDate
     *            Budget Period Reversal Date
     */
    public void setBudgetPeriodReversalDate( @Nullable final LocalDateTime budgetPeriodReversalDate )
    {
        rememberChangedField("BudgetPeriodReversalDate", this.budgetPeriodReversalDate);
        this.budgetPeriodReversalDate = budgetPeriodReversalDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodAuthznGrp</b>
     * </p>
     *
     * @param budgetPeriodAuthznGrp
     *            Budget Period Authorization Group
     */
    public void setBudgetPeriodAuthznGrp( @Nullable final String budgetPeriodAuthznGrp )
    {
        rememberChangedField("BudgetPeriodAuthznGrp", this.budgetPeriodAuthznGrp);
        this.budgetPeriodAuthznGrp = budgetPeriodAuthznGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodPeriodicity</b>
     * </p>
     *
     * @param budgetPeriodPeriodicity
     *            Frequency for Budget Period
     */
    public void setBudgetPeriodPeriodicity( @Nullable final String budgetPeriodPeriodicity )
    {
        rememberChangedField("BudgetPeriodPeriodicity", this.budgetPeriodPeriodicity);
        this.budgetPeriodPeriodicity = budgetPeriodPeriodicity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodName</b>
     * </p>
     *
     * @param budgetPeriodName
     *            Budget Period Name
     */
    public void setBudgetPeriodName( @Nullable final String budgetPeriodName )
    {
        rememberChangedField("BudgetPeriodName", this.budgetPeriodName);
        this.budgetPeriodName = budgetPeriodName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetPeriod";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BudgetPeriod", getBudgetPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("BudgetPeriodExpirationDate", getBudgetPeriodExpirationDate());
        values.put("BudgetPeriodReversalDate", getBudgetPeriodReversalDate());
        values.put("BudgetPeriodAuthznGrp", getBudgetPeriodAuthznGrp());
        values.put("BudgetPeriodPeriodicity", getBudgetPeriodPeriodicity());
        values.put("BudgetPeriodName", getBudgetPeriodName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BudgetPeriodExpirationDate") ) {
                final Object value = values.remove("BudgetPeriodExpirationDate");
                if( (value == null) || (!value.equals(getBudgetPeriodExpirationDate())) ) {
                    setBudgetPeriodExpirationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BudgetPeriodReversalDate") ) {
                final Object value = values.remove("BudgetPeriodReversalDate");
                if( (value == null) || (!value.equals(getBudgetPeriodReversalDate())) ) {
                    setBudgetPeriodReversalDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BudgetPeriodAuthznGrp") ) {
                final Object value = values.remove("BudgetPeriodAuthznGrp");
                if( (value == null) || (!value.equals(getBudgetPeriodAuthznGrp())) ) {
                    setBudgetPeriodAuthznGrp(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriodPeriodicity") ) {
                final Object value = values.remove("BudgetPeriodPeriodicity");
                if( (value == null) || (!value.equals(getBudgetPeriodPeriodicity())) ) {
                    setBudgetPeriodPeriodicity(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriodName") ) {
                final Object value = values.remove("BudgetPeriodName");
                if( (value == null) || (!value.equals(getBudgetPeriodName())) ) {
                    setBudgetPeriodName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetPeriodCoreText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BudgetPeriodCoreText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BudgetPeriodField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetPeriodField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetPeriodField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetPeriodField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetPeriodCoreText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetPeriodCoreText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreText> fetchText()
    {
        return fetchFieldAsList("to_Text", BudgetPeriodCoreText.class);
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetPeriodCoreText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetPeriod</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BudgetPeriodCoreText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<BudgetPeriodCoreText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BudgetPeriodCoreText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetPeriodCoreText</b> entities.
     */
    public void setText( @Nonnull final List<BudgetPeriodCoreText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetPeriodCoreText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriod</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetPeriodCoreText</b> entities.
     */
    public void addText( BudgetPeriodCoreText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BudgetPeriod instances.
     *
     */
    public final static class BudgetPeriodBuilder
    {

        private List<BudgetPeriodCoreText> toText = Lists.newArrayList();

        private BudgetPeriod.BudgetPeriodBuilder toText( final List<BudgetPeriodCoreText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BudgetPeriod</b> to multiple <b>BudgetPeriodCoreText</b>.
         *
         * @param value
         *            The BudgetPeriodCoreTexts to build this BudgetPeriod with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetPeriod.BudgetPeriodBuilder text( BudgetPeriodCoreText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
