/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.field.BudgetPeriodCoreTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.link.BudgetPeriodCoreTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.selectable.BudgetPeriodCoreTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Period Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetPeriodCoreText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetPeriodCoreText extends VdmEntity<BudgetPeriodCoreText>
{

    /**
     * Selector for all available fields of BudgetPeriodCoreText.
     *
     */
    public final static BudgetPeriodCoreTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreTextField<String> LANGUAGE = new BudgetPeriodCoreTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @Key
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreTextField<String> BUDGET_PERIOD =
        new BudgetPeriodCoreTextField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodName</b>
     * </p>
     *
     * @return Budget Period Name
     */
    @SerializedName( "BudgetPeriodName" )
    @JsonProperty( "BudgetPeriodName" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodName" )
    private String budgetPeriodName;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodName</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreTextField<String> BUDGET_PERIOD_NAME =
        new BudgetPeriodCoreTextField<String>("BudgetPeriodName");
    /**
     * Navigation property <b>to_BudgetPeriod</b> for <b>BudgetPeriodCoreText</b> to single <b>BudgetPeriod</b>.
     *
     */
    @SerializedName( "to_BudgetPeriod" )
    @JsonProperty( "to_BudgetPeriod" )
    @ODataField( odataName = "to_BudgetPeriod" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BudgetPeriod toBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>to_BudgetPeriod</b> navigation property to query operations.
     *
     */
    public final static BudgetPeriodCoreTextOneToOneLink<BudgetPeriod> TO_BUDGET_PERIOD =
        new BudgetPeriodCoreTextOneToOneLink<BudgetPeriod>("to_BudgetPeriod");

    @Nonnull
    @Override
    public Class<BudgetPeriodCoreText> getType()
    {
        return BudgetPeriodCoreText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodName</b>
     * </p>
     *
     * @param budgetPeriodName
     *            Budget Period Name
     */
    public void setBudgetPeriodName( @Nullable final String budgetPeriodName )
    {
        rememberChangedField("BudgetPeriodName", this.budgetPeriodName);
        this.budgetPeriodName = budgetPeriodName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetPeriodText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BudgetPeriod", getBudgetPeriod());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("BudgetPeriodName", getBudgetPeriodName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriodName") ) {
                final Object value = values.remove("BudgetPeriodName");
                if( (value == null) || (!value.equals(getBudgetPeriodName())) ) {
                    setBudgetPeriodName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BudgetPeriod") ) {
                final Object value = (values).remove("to_BudgetPeriod");
                if( value instanceof Map ) {
                    if( toBudgetPeriod == null ) {
                        toBudgetPeriod = new BudgetPeriod();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBudgetPeriod.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BudgetPeriodCoreTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetPeriodCoreTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetPeriodCoreTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetPeriodCoreTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBudgetPeriod != null ) {
            (values).put("to_BudgetPeriod", toBudgetPeriod);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetPeriod</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BudgetPeriod</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BudgetPeriod</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetPeriod fetchBudgetPeriod()
    {
        return fetchFieldAsSingle("to_BudgetPeriod", BudgetPeriod.class);
    }

    /**
     * Retrieval of associated <b>BudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BudgetPeriod</b>.
     * <p>
     * If the navigation property <b>to_BudgetPeriod</b> of a queried <b>BudgetPeriodCoreText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetPeriod</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetPeriod getBudgetPeriodOrFetch()
    {
        if( toBudgetPeriod == null ) {
            toBudgetPeriod = fetchBudgetPeriod();
        }
        return toBudgetPeriod;
    }

    /**
     * Retrieval of associated <b>BudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BudgetPeriod</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetPeriodCoreText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BudgetPeriod</b> is already loaded, the result will
     *         contain the <b>BudgetPeriod</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BudgetPeriod> getBudgetPeriodIfPresent()
    {
        return Option.of(toBudgetPeriod);
    }

    /**
     * Overwrites the associated <b>BudgetPeriod</b> entity for the loaded navigation property <b>to_BudgetPeriod</b>.
     *
     * @param value
     *            New <b>BudgetPeriod</b> entity.
     */
    public void setBudgetPeriod( final BudgetPeriod value )
    {
        toBudgetPeriod = value;
    }

    /**
     * Helper class to allow for fluent creation of BudgetPeriodCoreText instances.
     *
     */
    public final static class BudgetPeriodCoreTextBuilder
    {

        private BudgetPeriod toBudgetPeriod;
        private String budgetPeriod = null;

        private BudgetPeriodCoreText.BudgetPeriodCoreTextBuilder toBudgetPeriod( final BudgetPeriod value )
        {
            toBudgetPeriod = value;
            return this;
        }

        /**
         * Navigation property <b>to_BudgetPeriod</b> for <b>BudgetPeriodCoreText</b> to single <b>BudgetPeriod</b>.
         *
         * @param value
         *            The BudgetPeriod to build this BudgetPeriodCoreText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetPeriodCoreText.BudgetPeriodCoreTextBuilder budgetPeriod( final BudgetPeriod value )
        {
            return toBudgetPeriod(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BudgetPeriod</b>
         * </p>
         *
         * @param value
         *            The budgetPeriod to build this BudgetPeriodCoreText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetPeriodCoreText.BudgetPeriodCoreTextBuilder budgetPeriod( final String value )
        {
            budgetPeriod = value;
            return this;
        }

    }

}
