/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.selectable.BudgetPeriodCoreTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText BudgetPeriodCoreText}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BudgetPeriodCoreTextByKeyFluentHelper
    extends
    FluentHelperByKey<BudgetPeriodCoreTextByKeyFluentHelper, BudgetPeriodCoreText, BudgetPeriodCoreTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     * BudgetPeriodCoreText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BudgetPeriodCoreText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BudgetPeriodCoreText}
     * @param budgetPeriod
     *            Budget Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public BudgetPeriodCoreTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String budgetPeriod )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("BudgetPeriod", budgetPeriod);
    }

    @Override
    @Nonnull
    protected Class<BudgetPeriodCoreText> getEntityClass()
    {
        return BudgetPeriodCoreText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
