/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService BudgetPeriodService}.
 *
 */
public interface BudgetPeriodServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BudgetPeriodServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BudgetPeriodServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     * entity and save it to the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BudgetPeriodServiceBatchChangeSet createBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod
     * BudgetPeriod} entity and save it to the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BudgetPeriodServiceBatchChangeSet updateBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod
     * BudgetPeriod} entity in the S/4HANA system.
     *
     * @param budgetPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod BudgetPeriod}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BudgetPeriodServiceBatchChangeSet deleteBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     * BudgetPeriodCoreText} entity and save it to the S/4HANA system.
     *
     * @param budgetPeriodCoreText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText
     *            BudgetPeriodCoreText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BudgetPeriodServiceBatchChangeSet
        updateBudgetPeriodCoreText( @Nonnull final BudgetPeriodCoreText budgetPeriodCoreText );

}
