/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BudgetPeriodServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService BudgetPeriodService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBudgetPeriodServiceBatch
    extends
    BatchFluentHelperBasic<BudgetPeriodServiceBatch, BudgetPeriodServiceBatchChangeSet>
    implements
    BudgetPeriodServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBudgetPeriodServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetPeriodServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBudgetPeriodServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetPeriodServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBudgetPeriodServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BudgetPeriodServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBudgetPeriodServiceBatchChangeSet(this, service);
    }

}
