/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText;

/**
 * Implementation of the {@link BudgetPeriodServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService BudgetPeriodService}.
 *
 */
public class DefaultBudgetPeriodServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BudgetPeriodServiceBatch, BudgetPeriodServiceBatchChangeSet>
    implements
    BudgetPeriodServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService service;

    @SuppressWarnings( "deprecation" )
    DefaultBudgetPeriodServiceBatchChangeSet(
        @Nonnull final DefaultBudgetPeriodServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBudgetPeriodServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BudgetPeriodServiceBatchChangeSet createBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return addRequestCreate(service::createBudgetPeriod, budgetPeriod);
    }

    @Nonnull
    @Override
    public BudgetPeriodServiceBatchChangeSet updateBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return addRequestUpdate(service::updateBudgetPeriod, budgetPeriod);
    }

    @Nonnull
    @Override
    public BudgetPeriodServiceBatchChangeSet deleteBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return addRequestDelete(service::deleteBudgetPeriod, budgetPeriod);
    }

    @Nonnull
    @Override
    public BudgetPeriodServiceBatchChangeSet updateBudgetPeriodCoreText(
        @Nonnull final BudgetPeriodCoreText budgetPeriodCoreText )
    {
        return addRequestUpdate(service::updateBudgetPeriodCoreText, budgetPeriodCoreText);
    }

}
