/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText BudgetPeriodCoreText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.field.BudgetPeriodCoreTextField
 * BudgetPeriodCoreTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.link.BudgetPeriodCoreTextLink
 * BudgetPeriodCoreTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText#BUDGET_PERIOD_NAME
 * BUDGET_PERIOD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText#TO_BUDGET_PERIOD
 * TO_BUDGET_PERIOD}</li>
 * </ul>
 *
 */
public interface BudgetPeriodCoreTextSelectable extends EntitySelectable<BudgetPeriodCoreText>
{

}
