/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.field.BudgetPeriodCoreHierarchyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.link.BudgetPeriodCoreHierarchyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.selectable.BudgetPeriodCoreHierarchySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Budget Period Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BudgetPeriodCoreHierarchy_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BudgetPeriodCoreHierarchy extends VdmEntity<BudgetPeriodCoreHierarchy>
{

    /**
     * Selector for all available fields of BudgetPeriodCoreHierarchy.
     *
     */
    public final static BudgetPeriodCoreHierarchySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodHierarchy</b>
     * </p>
     *
     * @return Budget Period Hierarchy
     */
    @Key
    @SerializedName( "BudgetPeriodHierarchy" )
    @JsonProperty( "BudgetPeriodHierarchy" )
    @Nullable
    @ODataField( odataName = "BudgetPeriodHierarchy" )
    private String budgetPeriodHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodHierarchy</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreHierarchyField<String> BUDGET_PERIOD_HIERARCHY =
        new BudgetPeriodCoreHierarchyField<String>("BudgetPeriodHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreHierarchyField<LocalDateTime> VALIDITY_END_DATE =
        new BudgetPeriodCoreHierarchyField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static BudgetPeriodCoreHierarchyField<LocalDateTime> VALIDITY_START_DATE =
        new BudgetPeriodCoreHierarchyField<LocalDateTime>("ValidityStartDate");
    /**
     * Navigation property <b>to_BudgetPeriodCoreHierNode</b> for <b>BudgetPeriodCoreHierarchy</b> to multiple
     * <b>BudgetPeriodCoreHierNode</b>.
     *
     */
    @SerializedName( "to_BudgetPeriodCoreHierNode" )
    @JsonProperty( "to_BudgetPeriodCoreHierNode" )
    @ODataField( odataName = "to_BudgetPeriodCoreHierNode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetPeriodCoreHierNode> toBudgetPeriodCoreHierNode;
    /**
     * Navigation property <b>to_Text</b> for <b>BudgetPeriodCoreHierarchy</b> to multiple
     * <b>BudgetPeriodCoreHierarchyText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BudgetPeriodCoreHierarchyText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_BudgetPeriodCoreHierNode</b> navigation property to query
     * operations.
     *
     */
    public final static BudgetPeriodCoreHierarchyLink<BudgetPeriodCoreHierNode> TO_BUDGET_PERIOD_CORE_HIER_NODE =
        new BudgetPeriodCoreHierarchyLink<BudgetPeriodCoreHierNode>("to_BudgetPeriodCoreHierNode");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BudgetPeriodCoreHierarchyLink<BudgetPeriodCoreHierarchyText> TO_TEXT =
        new BudgetPeriodCoreHierarchyLink<BudgetPeriodCoreHierarchyText>("to_Text");

    @Nonnull
    @Override
    public Class<BudgetPeriodCoreHierarchy> getType()
    {
        return BudgetPeriodCoreHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriodHierarchy</b>
     * </p>
     *
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     */
    public void setBudgetPeriodHierarchy( @Nullable final String budgetPeriodHierarchy )
    {
        rememberChangedField("BudgetPeriodHierarchy", this.budgetPeriodHierarchy);
        this.budgetPeriodHierarchy = budgetPeriodHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BudgetPeriodHierarchy";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BudgetPeriodHierarchy", getBudgetPeriodHierarchy());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BudgetPeriodHierarchy", getBudgetPeriodHierarchy());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BudgetPeriodHierarchy") ) {
                final Object value = values.remove("BudgetPeriodHierarchy");
                if( (value == null) || (!value.equals(getBudgetPeriodHierarchy())) ) {
                    setBudgetPeriodHierarchy(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BudgetPeriodCoreHierNode") ) {
                final Object value = (values).remove("to_BudgetPeriodCoreHierNode");
                if( value instanceof Iterable ) {
                    if( toBudgetPeriodCoreHierNode == null ) {
                        toBudgetPeriodCoreHierNode = Lists.newArrayList();
                    } else {
                        toBudgetPeriodCoreHierNode = Lists.newArrayList(toBudgetPeriodCoreHierNode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetPeriodCoreHierNode entity;
                        if( toBudgetPeriodCoreHierNode.size() > i ) {
                            entity = toBudgetPeriodCoreHierNode.get(i);
                        } else {
                            entity = new BudgetPeriodCoreHierNode();
                            toBudgetPeriodCoreHierNode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BudgetPeriodCoreHierarchyText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BudgetPeriodCoreHierarchyText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BudgetPeriodCoreHierarchyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BudgetPeriodCoreHierarchyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BudgetPeriodCoreHierarchyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BudgetPeriodCoreHierarchyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBudgetPeriodCoreHierNode != null ) {
            (values).put("to_BudgetPeriodCoreHierNode", toBudgetPeriodCoreHierNode);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>BudgetPeriodCoreHierNode</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BudgetPeriodCoreHierNode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetPeriodCoreHierNode</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreHierNode> fetchBudgetPeriodCoreHierNode()
    {
        return fetchFieldAsList("to_BudgetPeriodCoreHierNode", BudgetPeriodCoreHierNode.class);
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreHierNode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BudgetPeriodCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetPeriodCoreHierNode</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetPeriodCoreHierNode</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreHierNode> getBudgetPeriodCoreHierNodeOrFetch()
    {
        if( toBudgetPeriodCoreHierNode == null ) {
            toBudgetPeriodCoreHierNode = fetchBudgetPeriodCoreHierNode();
        }
        return toBudgetPeriodCoreHierNode;
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreHierNode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BudgetPeriodCoreHierNode</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetPeriodCoreHierarchy</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BudgetPeriodCoreHierNode</b> is already loaded, the
     *         result will contain the <b>BudgetPeriodCoreHierNode</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BudgetPeriodCoreHierNode>> getBudgetPeriodCoreHierNodeIfPresent()
    {
        return Option.of(toBudgetPeriodCoreHierNode);
    }

    /**
     * Overwrites the list of associated <b>BudgetPeriodCoreHierNode</b> entities for the loaded navigation property
     * <b>to_BudgetPeriodCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetPeriodCoreHierNode</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetPeriodCoreHierNode</b> entities.
     */
    public void setBudgetPeriodCoreHierNode( @Nonnull final List<BudgetPeriodCoreHierNode> value )
    {
        if( toBudgetPeriodCoreHierNode == null ) {
            toBudgetPeriodCoreHierNode = Lists.newArrayList();
        }
        toBudgetPeriodCoreHierNode.clear();
        toBudgetPeriodCoreHierNode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetPeriodCoreHierNode</b> entities. This corresponds to the OData
     * navigation property <b>to_BudgetPeriodCoreHierNode</b>.
     * <p>
     * If the navigation property <b>to_BudgetPeriodCoreHierNode</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetPeriodCoreHierNode</b> entities.
     */
    public void addBudgetPeriodCoreHierNode( BudgetPeriodCoreHierNode... entity )
    {
        if( toBudgetPeriodCoreHierNode == null ) {
            toBudgetPeriodCoreHierNode = Lists.newArrayList();
        }
        toBudgetPeriodCoreHierNode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BudgetPeriodCoreHierarchyText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BudgetPeriodCoreHierarchyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreHierarchyText> fetchText()
    {
        return fetchFieldAsList("to_Text", BudgetPeriodCoreHierarchyText.class);
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreHierarchyText</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetPeriodCoreHierarchyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BudgetPeriodCoreHierarchyText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BudgetPeriodCoreHierarchyText</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BudgetPeriodCoreHierarchy</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BudgetPeriodCoreHierarchyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BudgetPeriodCoreHierarchyText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BudgetPeriodCoreHierarchyText</b> entities for the loaded navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BudgetPeriodCoreHierarchyText</b> entities.
     */
    public void setText( @Nonnull final List<BudgetPeriodCoreHierarchyText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BudgetPeriodCoreHierarchyText</b> entities. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BudgetPeriodCoreHierarchy</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BudgetPeriodCoreHierarchyText</b> entities.
     */
    public void addText( BudgetPeriodCoreHierarchyText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BudgetPeriodCoreHierarchy instances.
     *
     */
    public final static class BudgetPeriodCoreHierarchyBuilder
    {

        private List<BudgetPeriodCoreHierNode> toBudgetPeriodCoreHierNode = Lists.newArrayList();
        private List<BudgetPeriodCoreHierarchyText> toText = Lists.newArrayList();

        private BudgetPeriodCoreHierarchy.BudgetPeriodCoreHierarchyBuilder toBudgetPeriodCoreHierNode(
            final List<BudgetPeriodCoreHierNode> value )
        {
            toBudgetPeriodCoreHierNode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BudgetPeriodCoreHierNode</b> for <b>BudgetPeriodCoreHierarchy</b> to multiple
         * <b>BudgetPeriodCoreHierNode</b>.
         *
         * @param value
         *            The BudgetPeriodCoreHierNodes to build this BudgetPeriodCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetPeriodCoreHierarchy.BudgetPeriodCoreHierarchyBuilder budgetPeriodCoreHierNode(
            BudgetPeriodCoreHierNode... value )
        {
            return toBudgetPeriodCoreHierNode(Lists.newArrayList(value));
        }

        private BudgetPeriodCoreHierarchy.BudgetPeriodCoreHierarchyBuilder toText(
            final List<BudgetPeriodCoreHierarchyText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BudgetPeriodCoreHierarchy</b> to multiple
         * <b>BudgetPeriodCoreHierarchyText</b>.
         *
         * @param value
         *            The BudgetPeriodCoreHierarchyTexts to build this BudgetPeriodCoreHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BudgetPeriodCoreHierarchy.BudgetPeriodCoreHierarchyBuilder text( BudgetPeriodCoreHierarchyText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
