/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.selectable.BudgetPeriodCoreHierarchyNodeTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
 * BudgetPeriodCoreHierarchyNodeText} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper
    extends
    FluentHelperByKey<BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper, BudgetPeriodCoreHierarchyNodeText, BudgetPeriodCoreHierarchyNodeTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeText
     * BudgetPeriodCoreHierarchyNodeText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BudgetPeriodCoreHierarchyNodeText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BudgetPeriodCoreHierarchyNodeText}
     * @param budgetPeriodHierarchy
     *            Budget Period Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String budgetPeriodHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("BudgetPeriodHierarchy", budgetPeriodHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<BudgetPeriodCoreHierarchyNodeText> getEntityClass()
    {
        return BudgetPeriodCoreHierarchyNodeText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
