/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BudgetPeriodHierarchyServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService BudgetPeriodHierarchyService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBudgetPeriodHierarchyServiceBatch
    extends
    BatchFluentHelperBasic<BudgetPeriodHierarchyServiceBatch, BudgetPeriodHierarchyServiceBatchChangeSet>
    implements
    BudgetPeriodHierarchyServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBudgetPeriodHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetPeriodHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBudgetPeriodHierarchyServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBudgetPeriodHierarchyServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBudgetPeriodHierarchyServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BudgetPeriodHierarchyServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBudgetPeriodHierarchyServiceBatchChangeSet(this, service);
    }

}
