/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BudgetPeriodHierarchyServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService BudgetPeriodHierarchyService}.
 *
 */
public class DefaultBudgetPeriodHierarchyServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BudgetPeriodHierarchyServiceBatch, BudgetPeriodHierarchyServiceBatchChangeSet>
    implements
    BudgetPeriodHierarchyServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService service;

    @SuppressWarnings( "deprecation" )
    DefaultBudgetPeriodHierarchyServiceBatchChangeSet(
        @Nonnull final DefaultBudgetPeriodHierarchyServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BudgetPeriodHierarchyService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBudgetPeriodHierarchyServiceBatchChangeSet getThis()
    {
        return this;
    }

}
