/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode
 * BudgetPeriodCoreHierNode}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.field.BudgetPeriodCoreHierNodeField
 * BudgetPeriodCoreHierNodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.link.BudgetPeriodCoreHierNodeLink
 * BudgetPeriodCoreHierNodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#BUDGET_PERIOD_HIERARCHY
 * BUDGET_PERIOD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#HIERARCHY_NODE
 * HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#PARENT_NODE
 * PARENT_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#HIERARCHY_VERSION
 * HIERARCHY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#HIERARCHY_NODE_SEQUENCE
 * HIERARCHY_NODE_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#HIERARCHY_NODE_LEVEL
 * HIERARCHY_NODE_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#NODE_TYPE
 * NODE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#TO_BUDGET_PERIOD_CORE_HIERARCHY
 * TO_BUDGET_PERIOD_CORE_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNode#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface BudgetPeriodCoreHierNodeSelectable extends EntitySelectable<BudgetPeriodCoreHierNode>
{

}
