/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy
 * BudgetPeriodCoreHierarchy}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.field.BudgetPeriodCoreHierarchyField
 * BudgetPeriodCoreHierarchyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.link.BudgetPeriodCoreHierarchyLink
 * BudgetPeriodCoreHierarchyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy#BUDGET_PERIOD_HIERARCHY
 * BUDGET_PERIOD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy#TO_BUDGET_PERIOD_CORE_HIER_NODE
 * TO_BUDGET_PERIOD_CORE_HIER_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchy#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface BudgetPeriodCoreHierarchySelectable extends EntitySelectable<BudgetPeriodCoreHierarchy>
{

}
