/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText
 * BudgetPeriodCoreHierarchyText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.field.BudgetPeriodCoreHierarchyTextField
 * BudgetPeriodCoreHierarchyTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.link.BudgetPeriodCoreHierarchyTextLink
 * BudgetPeriodCoreHierarchyTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText#BUDGET_PERIOD_HIERARCHY
 * BUDGET_PERIOD_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyText#BUDGET_PERIOD_HIERARCHY_NAME
 * BUDGET_PERIOD_HIERARCHY_NAME}</li>
 * </ul>
 *
 */
public interface BudgetPeriodCoreHierarchyTextSelectable extends EntitySelectable<BudgetPeriodCoreHierarchyText>
{

}
