/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.field.ProfileAssignedToPlantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.link.ProfileAssignedToPlantLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.selectable.ProfileAssignedToPlantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Buffer Profile Assigned to Plant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProfileAssignedToPlantType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfileAssignedToPlant extends VdmEntity<ProfileAssignedToPlant>
{

    /**
     * Selector for all available fields of ProfileAssignedToPlant.
     *
     */
    public final static ProfileAssignedToPlantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<String> PLANT = new ProfileAssignedToPlantField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BufferProfileSetId</b>
     * </p>
     *
     * @return Set of Profiles
     */
    @SerializedName( "BufferProfileSetId" )
    @JsonProperty( "BufferProfileSetId" )
    @Nullable
    @ODataField( odataName = "BufferProfileSetId" )
    private String bufferProfileSetId;
    /**
     * Use with available fluent helpers to apply the <b>BufferProfileSetId</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<String> BUFFER_PROFILE_SET_ID =
        new ProfileAssignedToPlantField<String>("BufferProfileSetId");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeHorizonConstant</b>
     * </p>
     *
     * @return Spike Horizon Constant (SHC)
     */
    @SerializedName( "SpikeHorizonConstant" )
    @JsonProperty( "SpikeHorizonConstant" )
    @Nullable
    @ODataField( odataName = "SpikeHorizonConstant" )
    private BigDecimal spikeHorizonConstant;
    /**
     * Use with available fluent helpers to apply the <b>SpikeHorizonConstant</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<BigDecimal> SPIKE_HORIZON_CONSTANT =
        new ProfileAssignedToPlantField<BigDecimal>("SpikeHorizonConstant");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeHorizonMultiplier</b>
     * </p>
     *
     * @return Spike Horizon DLT Multiplier (SHM)
     */
    @SerializedName( "SpikeHorizonMultiplier" )
    @JsonProperty( "SpikeHorizonMultiplier" )
    @Nullable
    @ODataField( odataName = "SpikeHorizonMultiplier" )
    private BigDecimal spikeHorizonMultiplier;
    /**
     * Use with available fluent helpers to apply the <b>SpikeHorizonMultiplier</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<BigDecimal> SPIKE_HORIZON_MULTIPLIER =
        new ProfileAssignedToPlantField<BigDecimal>("SpikeHorizonMultiplier");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeThresholdFactor</b>
     * </p>
     *
     * @return Spike Threshold Factor
     */
    @SerializedName( "SpikeThresholdFactor" )
    @JsonProperty( "SpikeThresholdFactor" )
    @Nullable
    @ODataField( odataName = "SpikeThresholdFactor" )
    private BigDecimal spikeThresholdFactor;
    /**
     * Use with available fluent helpers to apply the <b>SpikeThresholdFactor</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<BigDecimal> SPIKE_THRESHOLD_FACTOR =
        new ProfileAssignedToPlantField<BigDecimal>("SpikeThresholdFactor");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OnHandAlertThldFctr</b>
     * </p>
     *
     * @return On-hand alert threshold factor
     */
    @SerializedName( "OnHandAlertThldFctr" )
    @JsonProperty( "OnHandAlertThldFctr" )
    @Nullable
    @ODataField( odataName = "OnHandAlertThldFctr" )
    private BigDecimal onHandAlertThldFctr;
    /**
     * Use with available fluent helpers to apply the <b>OnHandAlertThldFctr</b> field to query operations.
     *
     */
    public final static ProfileAssignedToPlantField<BigDecimal> ON_HAND_ALERT_THLD_FCTR =
        new ProfileAssignedToPlantField<BigDecimal>("OnHandAlertThldFctr");
    /**
     * Navigation property <b>to_ProfileDetails</b> for <b>ProfileAssignedToPlant</b> to multiple <b>ProfileDetails</b>.
     *
     */
    @SerializedName( "to_ProfileDetails" )
    @JsonProperty( "to_ProfileDetails" )
    @ODataField( odataName = "to_ProfileDetails" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProfileDetails> toProfileDetails;
    /**
     * Use with available fluent helpers to apply the <b>to_ProfileDetails</b> navigation property to query operations.
     *
     */
    public final static ProfileAssignedToPlantLink<ProfileDetails> TO_PROFILE_DETAILS =
        new ProfileAssignedToPlantLink<ProfileDetails>("to_ProfileDetails");

    @Nonnull
    @Override
    public Class<ProfileAssignedToPlant> getType()
    {
        return ProfileAssignedToPlant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BufferProfileSetId</b>
     * </p>
     *
     * @param bufferProfileSetId
     *            Set of Profiles
     */
    public void setBufferProfileSetId( @Nullable final String bufferProfileSetId )
    {
        rememberChangedField("BufferProfileSetId", this.bufferProfileSetId);
        this.bufferProfileSetId = bufferProfileSetId;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeHorizonConstant</b>
     * </p>
     *
     * @param spikeHorizonConstant
     *            Spike Horizon Constant (SHC)
     */
    public void setSpikeHorizonConstant( @Nullable final BigDecimal spikeHorizonConstant )
    {
        rememberChangedField("SpikeHorizonConstant", this.spikeHorizonConstant);
        this.spikeHorizonConstant = spikeHorizonConstant;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeHorizonMultiplier</b>
     * </p>
     *
     * @param spikeHorizonMultiplier
     *            Spike Horizon DLT Multiplier (SHM)
     */
    public void setSpikeHorizonMultiplier( @Nullable final BigDecimal spikeHorizonMultiplier )
    {
        rememberChangedField("SpikeHorizonMultiplier", this.spikeHorizonMultiplier);
        this.spikeHorizonMultiplier = spikeHorizonMultiplier;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpikeThresholdFactor</b>
     * </p>
     *
     * @param spikeThresholdFactor
     *            Spike Threshold Factor
     */
    public void setSpikeThresholdFactor( @Nullable final BigDecimal spikeThresholdFactor )
    {
        rememberChangedField("SpikeThresholdFactor", this.spikeThresholdFactor);
        this.spikeThresholdFactor = spikeThresholdFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OnHandAlertThldFctr</b>
     * </p>
     *
     * @param onHandAlertThldFctr
     *            On-hand alert threshold factor
     */
    public void setOnHandAlertThldFctr( @Nullable final BigDecimal onHandAlertThldFctr )
    {
        rememberChangedField("OnHandAlertThldFctr", this.onHandAlertThldFctr);
        this.onHandAlertThldFctr = onHandAlertThldFctr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProfileAssignedToPlant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Plant", getPlant());
        values.put("BufferProfileSetId", getBufferProfileSetId());
        values.put("SpikeHorizonConstant", getSpikeHorizonConstant());
        values.put("SpikeHorizonMultiplier", getSpikeHorizonMultiplier());
        values.put("SpikeThresholdFactor", getSpikeThresholdFactor());
        values.put("OnHandAlertThldFctr", getOnHandAlertThldFctr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BufferProfileSetId") ) {
                final Object value = values.remove("BufferProfileSetId");
                if( (value == null) || (!value.equals(getBufferProfileSetId())) ) {
                    setBufferProfileSetId(((String) value));
                }
            }
            if( values.containsKey("SpikeHorizonConstant") ) {
                final Object value = values.remove("SpikeHorizonConstant");
                if( (value == null) || (!value.equals(getSpikeHorizonConstant())) ) {
                    setSpikeHorizonConstant(((BigDecimal) value));
                }
            }
            if( values.containsKey("SpikeHorizonMultiplier") ) {
                final Object value = values.remove("SpikeHorizonMultiplier");
                if( (value == null) || (!value.equals(getSpikeHorizonMultiplier())) ) {
                    setSpikeHorizonMultiplier(((BigDecimal) value));
                }
            }
            if( values.containsKey("SpikeThresholdFactor") ) {
                final Object value = values.remove("SpikeThresholdFactor");
                if( (value == null) || (!value.equals(getSpikeThresholdFactor())) ) {
                    setSpikeThresholdFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("OnHandAlertThldFctr") ) {
                final Object value = values.remove("OnHandAlertThldFctr");
                if( (value == null) || (!value.equals(getOnHandAlertThldFctr())) ) {
                    setOnHandAlertThldFctr(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProfileDetails") ) {
                final Object value = (values).remove("to_ProfileDetails");
                if( value instanceof Iterable ) {
                    if( toProfileDetails == null ) {
                        toProfileDetails = Lists.newArrayList();
                    } else {
                        toProfileDetails = Lists.newArrayList(toProfileDetails);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProfileDetails entity;
                        if( toProfileDetails.size() > i ) {
                            entity = toProfileDetails.get(i);
                        } else {
                            entity = new ProfileDetails();
                            toProfileDetails.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProfileAssignedToPlantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProfileAssignedToPlantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfileAssignedToPlantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfileAssignedToPlantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProfileDetails != null ) {
            (values).put("to_ProfileDetails", toProfileDetails);
        }
        return values;
    }

    /**
     * Fetches the <b>ProfileDetails</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProfileDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProfileDetails</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfileDetails> fetchProfileDetails()
    {
        return fetchFieldAsList("to_ProfileDetails", ProfileDetails.class);
    }

    /**
     * Retrieval of associated <b>ProfileDetails</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProfileDetails</b>.
     * <p>
     * If the navigation property <b>to_ProfileDetails</b> of a queried <b>ProfileAssignedToPlant</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfileDetails</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfileDetails> getProfileDetailsOrFetch()
    {
        if( toProfileDetails == null ) {
            toProfileDetails = fetchProfileDetails();
        }
        return toProfileDetails;
    }

    /**
     * Retrieval of associated <b>ProfileDetails</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProfileDetails</b>.
     * <p>
     * If the navigation property for an entity <b>ProfileAssignedToPlant</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProfileDetails</b> is already loaded, the result will
     *         contain the <b>ProfileDetails</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProfileDetails>> getProfileDetailsIfPresent()
    {
        return Option.of(toProfileDetails);
    }

    /**
     * Overwrites the list of associated <b>ProfileDetails</b> entities for the loaded navigation property
     * <b>to_ProfileDetails</b>.
     * <p>
     * If the navigation property <b>to_ProfileDetails</b> of a queried <b>ProfileAssignedToPlant</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProfileDetails</b> entities.
     */
    public void setProfileDetails( @Nonnull final List<ProfileDetails> value )
    {
        if( toProfileDetails == null ) {
            toProfileDetails = Lists.newArrayList();
        }
        toProfileDetails.clear();
        toProfileDetails.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProfileDetails</b> entities. This corresponds to the OData navigation
     * property <b>to_ProfileDetails</b>.
     * <p>
     * If the navigation property <b>to_ProfileDetails</b> of a queried <b>ProfileAssignedToPlant</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProfileDetails</b> entities.
     */
    public void addProfileDetails( ProfileDetails... entity )
    {
        if( toProfileDetails == null ) {
            toProfileDetails = Lists.newArrayList();
        }
        toProfileDetails.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProfileAssignedToPlant instances.
     *
     */
    public final static class ProfileAssignedToPlantBuilder
    {

        private List<ProfileDetails> toProfileDetails = Lists.newArrayList();

        private ProfileAssignedToPlant.ProfileAssignedToPlantBuilder toProfileDetails(
            final List<ProfileDetails> value )
        {
            toProfileDetails.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProfileDetails</b> for <b>ProfileAssignedToPlant</b> to multiple
         * <b>ProfileDetails</b>.
         *
         * @param value
         *            The ProfileDetailss to build this ProfileAssignedToPlant with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfileAssignedToPlant.ProfileAssignedToPlantBuilder profileDetails( ProfileDetails... value )
        {
            return toProfileDetails(Lists.newArrayList(value));
        }

    }

}
