/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.field.ProfileDetailsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.link.ProfileDetailsOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.selectable.ProfileDetailsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Buffer Profile Details
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProfileDetailsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfileDetails extends VdmEntity<ProfileDetails>
{

    /**
     * Selector for all available fields of ProfileDetails.
     *
     */
    public final static ProfileDetailsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<String> PLANT = new ProfileDetailsField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @return Procurement Type
     */
    @Key
    @SerializedName( "ProcurementType" )
    @JsonProperty( "ProcurementType" )
    @Nullable
    @ODataField( odataName = "ProcurementType" )
    private String procurementType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementType</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<String> PROCUREMENT_TYPE =
        new ProfileDetailsField<String>("ProcurementType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityCode</b>
     * </p>
     *
     * @return Variability Co-efficient Indicator
     */
    @Key
    @SerializedName( "VariabilityCode" )
    @JsonProperty( "VariabilityCode" )
    @Nullable
    @ODataField( odataName = "VariabilityCode" )
    private String variabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityCode</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<String> VARIABILITY_CODE =
        new ProfileDetailsField<String>("VariabilityCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeCode</b>
     * </p>
     *
     * @return Decoupled Lead Time Indicator
     */
    @Key
    @SerializedName( "ReplenishmentLeadTimeCode" )
    @JsonProperty( "ReplenishmentLeadTimeCode" )
    @Nullable
    @ODataField( odataName = "ReplenishmentLeadTimeCode" )
    private String replenishmentLeadTimeCode;
    /**
     * Use with available fluent helpers to apply the <b>ReplenishmentLeadTimeCode</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<String> REPLENISHMENT_LEAD_TIME_CODE =
        new ProfileDetailsField<String>("ReplenishmentLeadTimeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMinOrderQtyConsidered</b>
     * </p>
     *
     * @return Is Minimum Order Quantity Considered
     */
    @Key
    @SerializedName( "IsMinOrderQtyConsidered" )
    @JsonProperty( "IsMinOrderQtyConsidered" )
    @Nullable
    @ODataField( odataName = "IsMinOrderQtyConsidered" )
    private String isMinOrderQtyConsidered;
    /**
     * Use with available fluent helpers to apply the <b>IsMinOrderQtyConsidered</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<String> IS_MIN_ORDER_QTY_CONSIDERED =
        new ProfileDetailsField<String>("IsMinOrderQtyConsidered");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityFactor</b>
     * </p>
     *
     * @return Variability Factor
     */
    @SerializedName( "VariabilityFactor" )
    @JsonProperty( "VariabilityFactor" )
    @Nullable
    @ODataField( odataName = "VariabilityFactor" )
    private BigDecimal variabilityFactor;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityFactor</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<BigDecimal> VARIABILITY_FACTOR =
        new ProfileDetailsField<BigDecimal>("VariabilityFactor");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeFactor</b>
     * </p>
     *
     * @return Decoupled Lead Time Factor
     */
    @SerializedName( "LeadTimeFactor" )
    @JsonProperty( "LeadTimeFactor" )
    @Nullable
    @ODataField( odataName = "LeadTimeFactor" )
    private BigDecimal leadTimeFactor;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeFactor</b> field to query operations.
     *
     */
    public final static ProfileDetailsField<BigDecimal> LEAD_TIME_FACTOR =
        new ProfileDetailsField<BigDecimal>("LeadTimeFactor");
    /**
     * Navigation property <b>to_ProfileAssignment</b> for <b>ProfileDetails</b> to single
     * <b>ProfileAssignedToPlant</b>.
     *
     */
    @SerializedName( "to_ProfileAssignment" )
    @JsonProperty( "to_ProfileAssignment" )
    @ODataField( odataName = "to_ProfileAssignment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProfileAssignedToPlant toProfileAssignment;
    /**
     * Use with available fluent helpers to apply the <b>to_ProfileAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static ProfileDetailsOneToOneLink<ProfileAssignedToPlant> TO_PROFILE_ASSIGNMENT =
        new ProfileDetailsOneToOneLink<ProfileAssignedToPlant>("to_ProfileAssignment");

    @Nonnull
    @Override
    public Class<ProfileDetails> getType()
    {
        return ProfileDetails.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @param procurementType
     *            Procurement Type
     */
    public void setProcurementType( @Nullable final String procurementType )
    {
        rememberChangedField("ProcurementType", this.procurementType);
        this.procurementType = procurementType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityCode</b>
     * </p>
     *
     * @param variabilityCode
     *            Variability Co-efficient Indicator
     */
    public void setVariabilityCode( @Nullable final String variabilityCode )
    {
        rememberChangedField("VariabilityCode", this.variabilityCode);
        this.variabilityCode = variabilityCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeCode</b>
     * </p>
     *
     * @param replenishmentLeadTimeCode
     *            Decoupled Lead Time Indicator
     */
    public void setReplenishmentLeadTimeCode( @Nullable final String replenishmentLeadTimeCode )
    {
        rememberChangedField("ReplenishmentLeadTimeCode", this.replenishmentLeadTimeCode);
        this.replenishmentLeadTimeCode = replenishmentLeadTimeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMinOrderQtyConsidered</b>
     * </p>
     *
     * @param isMinOrderQtyConsidered
     *            Is Minimum Order Quantity Considered
     */
    public void setIsMinOrderQtyConsidered( @Nullable final String isMinOrderQtyConsidered )
    {
        rememberChangedField("IsMinOrderQtyConsidered", this.isMinOrderQtyConsidered);
        this.isMinOrderQtyConsidered = isMinOrderQtyConsidered;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityFactor</b>
     * </p>
     *
     * @param variabilityFactor
     *            Variability Factor
     */
    public void setVariabilityFactor( @Nullable final BigDecimal variabilityFactor )
    {
        rememberChangedField("VariabilityFactor", this.variabilityFactor);
        this.variabilityFactor = variabilityFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeFactor</b>
     * </p>
     *
     * @param leadTimeFactor
     *            Decoupled Lead Time Factor
     */
    public void setLeadTimeFactor( @Nullable final BigDecimal leadTimeFactor )
    {
        rememberChangedField("LeadTimeFactor", this.leadTimeFactor);
        this.leadTimeFactor = leadTimeFactor;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProfileDetails";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Plant", getPlant());
        result.put("ProcurementType", getProcurementType());
        result.put("VariabilityCode", getVariabilityCode());
        result.put("ReplenishmentLeadTimeCode", getReplenishmentLeadTimeCode());
        result.put("IsMinOrderQtyConsidered", getIsMinOrderQtyConsidered());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Plant", getPlant());
        values.put("ProcurementType", getProcurementType());
        values.put("VariabilityCode", getVariabilityCode());
        values.put("ReplenishmentLeadTimeCode", getReplenishmentLeadTimeCode());
        values.put("IsMinOrderQtyConsidered", getIsMinOrderQtyConsidered());
        values.put("VariabilityFactor", getVariabilityFactor());
        values.put("LeadTimeFactor", getLeadTimeFactor());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProcurementType") ) {
                final Object value = values.remove("ProcurementType");
                if( (value == null) || (!value.equals(getProcurementType())) ) {
                    setProcurementType(((String) value));
                }
            }
            if( values.containsKey("VariabilityCode") ) {
                final Object value = values.remove("VariabilityCode");
                if( (value == null) || (!value.equals(getVariabilityCode())) ) {
                    setVariabilityCode(((String) value));
                }
            }
            if( values.containsKey("ReplenishmentLeadTimeCode") ) {
                final Object value = values.remove("ReplenishmentLeadTimeCode");
                if( (value == null) || (!value.equals(getReplenishmentLeadTimeCode())) ) {
                    setReplenishmentLeadTimeCode(((String) value));
                }
            }
            if( values.containsKey("IsMinOrderQtyConsidered") ) {
                final Object value = values.remove("IsMinOrderQtyConsidered");
                if( (value == null) || (!value.equals(getIsMinOrderQtyConsidered())) ) {
                    setIsMinOrderQtyConsidered(((String) value));
                }
            }
            if( values.containsKey("VariabilityFactor") ) {
                final Object value = values.remove("VariabilityFactor");
                if( (value == null) || (!value.equals(getVariabilityFactor())) ) {
                    setVariabilityFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("LeadTimeFactor") ) {
                final Object value = values.remove("LeadTimeFactor");
                if( (value == null) || (!value.equals(getLeadTimeFactor())) ) {
                    setLeadTimeFactor(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProfileAssignment") ) {
                final Object value = (values).remove("to_ProfileAssignment");
                if( value instanceof Map ) {
                    if( toProfileAssignment == null ) {
                        toProfileAssignment = new ProfileAssignedToPlant();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProfileAssignment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProfileDetailsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProfileDetailsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfileDetailsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfileDetailsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProfileAssignment != null ) {
            (values).put("to_ProfileAssignment", toProfileAssignment);
        }
        return values;
    }

    /**
     * Fetches the <b>ProfileAssignedToPlant</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProfileAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProfileAssignedToPlant</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProfileAssignedToPlant fetchProfileAssignment()
    {
        return fetchFieldAsSingle("to_ProfileAssignment", ProfileAssignedToPlant.class);
    }

    /**
     * Retrieval of associated <b>ProfileAssignedToPlant</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProfileAssignment</b>.
     * <p>
     * If the navigation property <b>to_ProfileAssignment</b> of a queried <b>ProfileDetails</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfileAssignedToPlant</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProfileAssignedToPlant getProfileAssignmentOrFetch()
    {
        if( toProfileAssignment == null ) {
            toProfileAssignment = fetchProfileAssignment();
        }
        return toProfileAssignment;
    }

    /**
     * Retrieval of associated <b>ProfileAssignedToPlant</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ProfileAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>ProfileDetails</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProfileAssignment</b> is already loaded, the result will
     *         contain the <b>ProfileAssignedToPlant</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProfileAssignedToPlant> getProfileAssignmentIfPresent()
    {
        return Option.of(toProfileAssignment);
    }

    /**
     * Overwrites the associated <b>ProfileAssignedToPlant</b> entity for the loaded navigation property
     * <b>to_ProfileAssignment</b>.
     *
     * @param value
     *            New <b>ProfileAssignedToPlant</b> entity.
     */
    public void setProfileAssignment( final ProfileAssignedToPlant value )
    {
        toProfileAssignment = value;
    }

    /**
     * Helper class to allow for fluent creation of ProfileDetails instances.
     *
     */
    public final static class ProfileDetailsBuilder
    {

        private ProfileAssignedToPlant toProfileAssignment;

        private ProfileDetails.ProfileDetailsBuilder toProfileAssignment( final ProfileAssignedToPlant value )
        {
            toProfileAssignment = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProfileAssignment</b> for <b>ProfileDetails</b> to single
         * <b>ProfileAssignedToPlant</b>.
         *
         * @param value
         *            The ProfileAssignedToPlant to build this ProfileDetails with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfileDetails.ProfileDetailsBuilder profileAssignment( final ProfileAssignedToPlant value )
        {
            return toProfileAssignment(value);
        }

    }

}
