/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BufferProfileServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService BufferProfileService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBufferProfileServiceBatch
    extends
    BatchFluentHelperBasic<BufferProfileServiceBatch, BufferProfileServiceBatchChangeSet>
    implements
    BufferProfileServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBufferProfileServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBufferProfileServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBufferProfileServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBufferProfileServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBufferProfileServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BufferProfileServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBufferProfileServiceBatchChangeSet(this, service);
    }

}
