/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BufferProfileServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService BufferProfileService}.
 *
 */
public class DefaultBufferProfileServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BufferProfileServiceBatch, BufferProfileServiceBatchChangeSet>
    implements
    BufferProfileServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService service;

    @SuppressWarnings( "deprecation" )
    DefaultBufferProfileServiceBatchChangeSet(
        @Nonnull final DefaultBufferProfileServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferProfileService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBufferProfileServiceBatchChangeSet getThis()
    {
        return this;
    }

}
