/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant
 * ProfileAssignedToPlant}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.field.ProfileAssignedToPlantField
 * ProfileAssignedToPlantField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.link.ProfileAssignedToPlantLink
 * ProfileAssignedToPlantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#BUFFER_PROFILE_SET_ID
 * BUFFER_PROFILE_SET_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#SPIKE_HORIZON_CONSTANT
 * SPIKE_HORIZON_CONSTANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#SPIKE_HORIZON_MULTIPLIER
 * SPIKE_HORIZON_MULTIPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#SPIKE_THRESHOLD_FACTOR
 * SPIKE_THRESHOLD_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#ON_HAND_ALERT_THLD_FCTR
 * ON_HAND_ALERT_THLD_FCTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlant#TO_PROFILE_DETAILS
 * TO_PROFILE_DETAILS}</li>
 * </ul>
 *
 */
public interface ProfileAssignedToPlantSelectable extends EntitySelectable<ProfileAssignedToPlant>
{

}
