/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails ProfileDetails}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.field.ProfileDetailsField
 * ProfileDetailsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.link.ProfileDetailsLink ProfileDetailsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#PROCUREMENT_TYPE
 * PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#VARIABILITY_CODE
 * VARIABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#REPLENISHMENT_LEAD_TIME_CODE
 * REPLENISHMENT_LEAD_TIME_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#IS_MIN_ORDER_QTY_CONSIDERED
 * IS_MIN_ORDER_QTY_CONSIDERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#VARIABILITY_FACTOR
 * VARIABILITY_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#LEAD_TIME_FACTOR
 * LEAD_TIME_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetails#TO_PROFILE_ASSIGNMENT
 * TO_PROFILE_ASSIGNMENT}</li>
 * </ul>
 *
 */
public interface ProfileDetailsSelectable extends EntitySelectable<ProfileDetails>
{

}
