/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ActualStockField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ActualStockOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.ActualStockSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Actual Stock
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ActualStockType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ActualStock extends VdmEntity<ActualStock>
{

    /**
     * Selector for all available fields of ActualStock.
     *
     */
    public final static ActualStockSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ActualStockField<String> MATERIAL = new ActualStockField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ActualStockField<String> PLANT = new ActualStockField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ActualStockField<String> MRP_AREA = new ActualStockField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufferLevelStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @Key
    @SerializedName( "BufferLevelStartDate" )
    @JsonProperty( "BufferLevelStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BufferLevelStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bufferLevelStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BufferLevelStartDate</b> field to query operations.
     *
     */
    public final static ActualStockField<LocalDateTime> BUFFER_LEVEL_START_DATE =
        new ActualStockField<LocalDateTime>("BufferLevelStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufferLevelEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "BufferLevelEndDate" )
    @JsonProperty( "BufferLevelEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BufferLevelEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bufferLevelEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BufferLevelEndDate</b> field to query operations.
     *
     */
    public final static ActualStockField<LocalDateTime> BUFFER_LEVEL_END_DATE =
        new ActualStockField<LocalDateTime>("BufferLevelEndDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSafetyStockQty</b>
     * </p>
     *
     * @return Safety Stock
     */
    @SerializedName( "MaterialSafetyStockQty" )
    @JsonProperty( "MaterialSafetyStockQty" )
    @Nullable
    @ODataField( odataName = "MaterialSafetyStockQty" )
    private BigDecimal materialSafetyStockQty;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSafetyStockQty</b> field to query operations.
     *
     */
    public final static ActualStockField<BigDecimal> MATERIAL_SAFETY_STOCK_QTY =
        new ActualStockField<BigDecimal>("MaterialSafetyStockQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @return Reorder Point
     */
    @SerializedName( "ReorderThresholdQuantity" )
    @JsonProperty( "ReorderThresholdQuantity" )
    @Nullable
    @ODataField( odataName = "ReorderThresholdQuantity" )
    private BigDecimal reorderThresholdQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReorderThresholdQuantity</b> field to query operations.
     *
     */
    public final static ActualStockField<BigDecimal> REORDER_THRESHOLD_QUANTITY =
        new ActualStockField<BigDecimal>("ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxStockLevelQuantity</b>
     * </p>
     *
     * @return Maximum Stock Level
     */
    @SerializedName( "MaterialMaxStockLevelQuantity" )
    @JsonProperty( "MaterialMaxStockLevelQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialMaxStockLevelQuantity" )
    private BigDecimal materialMaxStockLevelQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialMaxStockLevelQuantity</b> field to query operations.
     *
     */
    public final static ActualStockField<BigDecimal> MATERIAL_MAX_STOCK_LEVEL_QUANTITY =
        new ActualStockField<BigDecimal>("MaterialMaxStockLevelQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ActualStockField<String> BASE_UNIT = new ActualStockField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeMode</b>
     * </p>
     *
     * @return Mode of change
     */
    @SerializedName( "ChangeMode" )
    @JsonProperty( "ChangeMode" )
    @Nullable
    @ODataField( odataName = "ChangeMode" )
    private String changeMode;
    /**
     * Use with available fluent helpers to apply the <b>ChangeMode</b> field to query operations.
     *
     */
    public final static ActualStockField<String> CHANGE_MODE = new ActualStockField<String>("ChangeMode");
    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     *
     * @return Proposal Id
     */
    @SerializedName( "StockLevelProposalID" )
    @JsonProperty( "StockLevelProposalID" )
    @Nullable
    @ODataField( odataName = "StockLevelProposalID" )
    private String stockLevelProposalID;
    /**
     * Use with available fluent helpers to apply the <b>StockLevelProposalID</b> field to query operations.
     *
     */
    public final static ActualStockField<String> STOCK_LEVEL_PROPOSAL_ID =
        new ActualStockField<String>("StockLevelProposalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @return Proposal Version
     */
    @SerializedName( "ProposalVersion" )
    @JsonProperty( "ProposalVersion" )
    @Nullable
    @ODataField( odataName = "ProposalVersion" )
    private String proposalVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProposalVersion</b> field to query operations.
     *
     */
    public final static ActualStockField<String> PROPOSAL_VERSION = new ActualStockField<String>("ProposalVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @return Proposal Validity From Date
     */
    @SerializedName( "ProposalStartDate" )
    @JsonProperty( "ProposalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStartDate</b> field to query operations.
     *
     */
    public final static ActualStockField<LocalDateTime> PROPOSAL_START_DATE =
        new ActualStockField<LocalDateTime>("ProposalStartDate");
    /**
     * Navigation property <b>to_ProposalHdr</b> for <b>ActualStock</b> to single <b>ProposalHeader</b>.
     *
     */
    @SerializedName( "to_ProposalHdr" )
    @JsonProperty( "to_ProposalHdr" )
    @ODataField( odataName = "to_ProposalHdr" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProposalHeader toProposalHdr;
    /**
     * Use with available fluent helpers to apply the <b>to_ProposalHdr</b> navigation property to query operations.
     *
     */
    public final static ActualStockOneToOneLink<ProposalHeader> TO_PROPOSAL_HDR =
        new ActualStockOneToOneLink<ProposalHeader>("to_ProposalHdr");

    @Nonnull
    @Override
    public Class<ActualStock> getType()
    {
        return ActualStock.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufferLevelStartDate</b>
     * </p>
     *
     * @param bufferLevelStartDate
     *            Valid-From Date
     */
    public void setBufferLevelStartDate( @Nullable final LocalDateTime bufferLevelStartDate )
    {
        rememberChangedField("BufferLevelStartDate", this.bufferLevelStartDate);
        this.bufferLevelStartDate = bufferLevelStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufferLevelEndDate</b>
     * </p>
     *
     * @param bufferLevelEndDate
     *            Valid-To Date
     */
    public void setBufferLevelEndDate( @Nullable final LocalDateTime bufferLevelEndDate )
    {
        rememberChangedField("BufferLevelEndDate", this.bufferLevelEndDate);
        this.bufferLevelEndDate = bufferLevelEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSafetyStockQty</b>
     * </p>
     *
     * @param materialSafetyStockQty
     *            Safety Stock
     */
    public void setMaterialSafetyStockQty( @Nullable final BigDecimal materialSafetyStockQty )
    {
        rememberChangedField("MaterialSafetyStockQty", this.materialSafetyStockQty);
        this.materialSafetyStockQty = materialSafetyStockQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     *
     * @param reorderThresholdQuantity
     *            Reorder Point
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxStockLevelQuantity</b>
     * </p>
     *
     * @param materialMaxStockLevelQuantity
     *            Maximum Stock Level
     */
    public void setMaterialMaxStockLevelQuantity( @Nullable final BigDecimal materialMaxStockLevelQuantity )
    {
        rememberChangedField("MaterialMaxStockLevelQuantity", this.materialMaxStockLevelQuantity);
        this.materialMaxStockLevelQuantity = materialMaxStockLevelQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ChangeMode</b>
     * </p>
     *
     * @param changeMode
     *            Mode of change
     */
    public void setChangeMode( @Nullable final String changeMode )
    {
        rememberChangedField("ChangeMode", this.changeMode);
        this.changeMode = changeMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     *
     * @param stockLevelProposalID
     *            Proposal Id
     */
    public void setStockLevelProposalID( @Nullable final String stockLevelProposalID )
    {
        rememberChangedField("StockLevelProposalID", this.stockLevelProposalID);
        this.stockLevelProposalID = stockLevelProposalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDateTime proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ActualStock";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("BufferLevelStartDate", getBufferLevelStartDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("BufferLevelStartDate", getBufferLevelStartDate());
        values.put("BufferLevelEndDate", getBufferLevelEndDate());
        values.put("MaterialSafetyStockQty", getMaterialSafetyStockQty());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("MaterialMaxStockLevelQuantity", getMaterialMaxStockLevelQuantity());
        values.put("BaseUnit", getBaseUnit());
        values.put("ChangeMode", getChangeMode());
        values.put("StockLevelProposalID", getStockLevelProposalID());
        values.put("ProposalVersion", getProposalVersion());
        values.put("ProposalStartDate", getProposalStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("BufferLevelStartDate") ) {
                final Object value = values.remove("BufferLevelStartDate");
                if( (value == null) || (!value.equals(getBufferLevelStartDate())) ) {
                    setBufferLevelStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BufferLevelEndDate") ) {
                final Object value = values.remove("BufferLevelEndDate");
                if( (value == null) || (!value.equals(getBufferLevelEndDate())) ) {
                    setBufferLevelEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaterialSafetyStockQty") ) {
                final Object value = values.remove("MaterialSafetyStockQty");
                if( (value == null) || (!value.equals(getMaterialSafetyStockQty())) ) {
                    setMaterialSafetyStockQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialMaxStockLevelQuantity") ) {
                final Object value = values.remove("MaterialMaxStockLevelQuantity");
                if( (value == null) || (!value.equals(getMaterialMaxStockLevelQuantity())) ) {
                    setMaterialMaxStockLevelQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ChangeMode") ) {
                final Object value = values.remove("ChangeMode");
                if( (value == null) || (!value.equals(getChangeMode())) ) {
                    setChangeMode(((String) value));
                }
            }
            if( values.containsKey("StockLevelProposalID") ) {
                final Object value = values.remove("StockLevelProposalID");
                if( (value == null) || (!value.equals(getStockLevelProposalID())) ) {
                    setStockLevelProposalID(((String) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProposalHdr") ) {
                final Object value = (values).remove("to_ProposalHdr");
                if( value instanceof Map ) {
                    if( toProposalHdr == null ) {
                        toProposalHdr = new ProposalHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProposalHdr.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ActualStockField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ActualStockField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ActualStockField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ActualStockField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProposalHdr != null ) {
            (values).put("to_ProposalHdr", toProposalHdr);
        }
        return values;
    }

    /**
     * Fetches the <b>ProposalHeader</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProposalHdr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProposalHeader</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader fetchProposalHdr()
    {
        return fetchFieldAsSingle("to_ProposalHdr", ProposalHeader.class);
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property <b>to_ProposalHdr</b> of a queried <b>ActualStock</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProposalHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader getProposalHdrOrFetch()
    {
        if( toProposalHdr == null ) {
            toProposalHdr = fetchProposalHdr();
        }
        return toProposalHdr;
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property for an entity <b>ActualStock</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProposalHdr</b> is already loaded, the result will
     *         contain the <b>ProposalHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProposalHeader> getProposalHdrIfPresent()
    {
        return Option.of(toProposalHdr);
    }

    /**
     * Overwrites the associated <b>ProposalHeader</b> entity for the loaded navigation property <b>to_ProposalHdr</b>.
     *
     * @param value
     *            New <b>ProposalHeader</b> entity.
     */
    public void setProposalHdr( final ProposalHeader value )
    {
        toProposalHdr = value;
    }

    /**
     * Helper class to allow for fluent creation of ActualStock instances.
     *
     */
    public final static class ActualStockBuilder
    {

        private ProposalHeader toProposalHdr;

        private ActualStock.ActualStockBuilder toProposalHdr( final ProposalHeader value )
        {
            toProposalHdr = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProposalHdr</b> for <b>ActualStock</b> to single <b>ProposalHeader</b>.
         *
         * @param value
         *            The ProposalHeader to build this ActualStock with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ActualStock.ActualStockBuilder proposalHdr( final ProposalHeader value )
        {
            return toProposalHdr(value);
        }

    }

}
