/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.DemandAdjustmentsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.DemandAdjustmentsOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.DemandAdjustmentsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Average Daily Usage
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DemandAdjustmentsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DemandAdjustments extends VdmEntity<DemandAdjustments>
{

    /**
     * Selector for all available fields of DemandAdjustments.
     *
     */
    public final static DemandAdjustmentsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<String> MATERIAL = new DemandAdjustmentsField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<String> PLANT = new DemandAdjustmentsField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<String> MRP_AREA = new DemandAdjustmentsField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @return Proposal Validity From Date
     */
    @Key
    @SerializedName( "ProposalStartDate" )
    @JsonProperty( "ProposalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStartDate</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<LocalDateTime> PROPOSAL_START_DATE =
        new DemandAdjustmentsField<LocalDateTime>("ProposalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @return Proposal Version
     */
    @Key
    @SerializedName( "ProposalVersion" )
    @JsonProperty( "ProposalVersion" )
    @Nullable
    @ODataField( odataName = "ProposalVersion" )
    private String proposalVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProposalVersion</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<String> PROPOSAL_VERSION =
        new DemandAdjustmentsField<String>("ProposalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalDmndAdjmtFctrStartDate</b>
     * </p>
     *
     * @return Proposal Details Valid From
     */
    @Key
    @SerializedName( "ProposalDmndAdjmtFctrStartDate" )
    @JsonProperty( "ProposalDmndAdjmtFctrStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalDmndAdjmtFctrStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalDmndAdjmtFctrStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalDmndAdjmtFctrStartDate</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<LocalDateTime> PROPOSAL_DMND_ADJMT_FCTR_START_DATE =
        new DemandAdjustmentsField<LocalDateTime>("ProposalDmndAdjmtFctrStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalDmndAdjmtFctrEndDate</b>
     * </p>
     *
     * @return Proposal Details Valid To
     */
    @SerializedName( "ProposalDmndAdjmtFctrEndDate" )
    @JsonProperty( "ProposalDmndAdjmtFctrEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalDmndAdjmtFctrEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalDmndAdjmtFctrEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalDmndAdjmtFctrEndDate</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<LocalDateTime> PROPOSAL_DMND_ADJMT_FCTR_END_DATE =
        new DemandAdjustmentsField<LocalDateTime>("ProposalDmndAdjmtFctrEndDate");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DemandAdjustmentFactor</b>
     * </p>
     *
     * @return Demand Adjustment Factor
     */
    @SerializedName( "DemandAdjustmentFactor" )
    @JsonProperty( "DemandAdjustmentFactor" )
    @Nullable
    @ODataField( odataName = "DemandAdjustmentFactor" )
    private BigDecimal demandAdjustmentFactor;
    /**
     * Use with available fluent helpers to apply the <b>DemandAdjustmentFactor</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<BigDecimal> DEMAND_ADJUSTMENT_FACTOR =
        new DemandAdjustmentsField<BigDecimal>("DemandAdjustmentFactor");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AverageDailyUsage</b>
     * </p>
     *
     * @return Average Daily Usage
     */
    @SerializedName( "AverageDailyUsage" )
    @JsonProperty( "AverageDailyUsage" )
    @Nullable
    @ODataField( odataName = "AverageDailyUsage" )
    private BigDecimal averageDailyUsage;
    /**
     * Use with available fluent helpers to apply the <b>AverageDailyUsage</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<BigDecimal> AVERAGE_DAILY_USAGE =
        new DemandAdjustmentsField<BigDecimal>("AverageDailyUsage");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedAverageDailyUsage</b>
     * </p>
     *
     * @return Average Daily Usage
     */
    @SerializedName( "AdjustedAverageDailyUsage" )
    @JsonProperty( "AdjustedAverageDailyUsage" )
    @Nullable
    @ODataField( odataName = "AdjustedAverageDailyUsage" )
    private BigDecimal adjustedAverageDailyUsage;
    /**
     * Use with available fluent helpers to apply the <b>AdjustedAverageDailyUsage</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<BigDecimal> ADJUSTED_AVERAGE_DAILY_USAGE =
        new DemandAdjustmentsField<BigDecimal>("AdjustedAverageDailyUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AvgDailyUsageUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "AvgDailyUsageUnit" )
    @JsonProperty( "AvgDailyUsageUnit" )
    @Nullable
    @ODataField( odataName = "AvgDailyUsageUnit" )
    private String avgDailyUsageUnit;
    /**
     * Use with available fluent helpers to apply the <b>AvgDailyUsageUnit</b> field to query operations.
     *
     */
    public final static DemandAdjustmentsField<String> AVG_DAILY_USAGE_UNIT =
        new DemandAdjustmentsField<String>("AvgDailyUsageUnit");
    /**
     * Navigation property <b>to_ProposalHdr</b> for <b>DemandAdjustments</b> to single <b>ProposalHeader</b>.
     *
     */
    @SerializedName( "to_ProposalHdr" )
    @JsonProperty( "to_ProposalHdr" )
    @ODataField( odataName = "to_ProposalHdr" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProposalHeader toProposalHdr;
    /**
     * Use with available fluent helpers to apply the <b>to_ProposalHdr</b> navigation property to query operations.
     *
     */
    public final static DemandAdjustmentsOneToOneLink<ProposalHeader> TO_PROPOSAL_HDR =
        new DemandAdjustmentsOneToOneLink<ProposalHeader>("to_ProposalHdr");

    @Nonnull
    @Override
    public Class<DemandAdjustments> getType()
    {
        return DemandAdjustments.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDateTime proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalDmndAdjmtFctrStartDate</b>
     * </p>
     *
     * @param proposalDmndAdjmtFctrStartDate
     *            Proposal Details Valid From
     */
    public void setProposalDmndAdjmtFctrStartDate( @Nullable final LocalDateTime proposalDmndAdjmtFctrStartDate )
    {
        rememberChangedField("ProposalDmndAdjmtFctrStartDate", this.proposalDmndAdjmtFctrStartDate);
        this.proposalDmndAdjmtFctrStartDate = proposalDmndAdjmtFctrStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalDmndAdjmtFctrEndDate</b>
     * </p>
     *
     * @param proposalDmndAdjmtFctrEndDate
     *            Proposal Details Valid To
     */
    public void setProposalDmndAdjmtFctrEndDate( @Nullable final LocalDateTime proposalDmndAdjmtFctrEndDate )
    {
        rememberChangedField("ProposalDmndAdjmtFctrEndDate", this.proposalDmndAdjmtFctrEndDate);
        this.proposalDmndAdjmtFctrEndDate = proposalDmndAdjmtFctrEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DemandAdjustmentFactor</b>
     * </p>
     *
     * @param demandAdjustmentFactor
     *            Demand Adjustment Factor
     */
    public void setDemandAdjustmentFactor( @Nullable final BigDecimal demandAdjustmentFactor )
    {
        rememberChangedField("DemandAdjustmentFactor", this.demandAdjustmentFactor);
        this.demandAdjustmentFactor = demandAdjustmentFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AverageDailyUsage</b>
     * </p>
     *
     * @param averageDailyUsage
     *            Average Daily Usage
     */
    public void setAverageDailyUsage( @Nullable final BigDecimal averageDailyUsage )
    {
        rememberChangedField("AverageDailyUsage", this.averageDailyUsage);
        this.averageDailyUsage = averageDailyUsage;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdjustedAverageDailyUsage</b>
     * </p>
     *
     * @param adjustedAverageDailyUsage
     *            Average Daily Usage
     */
    public void setAdjustedAverageDailyUsage( @Nullable final BigDecimal adjustedAverageDailyUsage )
    {
        rememberChangedField("AdjustedAverageDailyUsage", this.adjustedAverageDailyUsage);
        this.adjustedAverageDailyUsage = adjustedAverageDailyUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AvgDailyUsageUnit</b>
     * </p>
     *
     * @param avgDailyUsageUnit
     *            Base Unit of Measure
     */
    public void setAvgDailyUsageUnit( @Nullable final String avgDailyUsageUnit )
    {
        rememberChangedField("AvgDailyUsageUnit", this.avgDailyUsageUnit);
        this.avgDailyUsageUnit = avgDailyUsageUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DemandAdjustments";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("ProposalStartDate", getProposalStartDate());
        result.put("ProposalVersion", getProposalVersion());
        result.put("ProposalDmndAdjmtFctrStartDate", getProposalDmndAdjmtFctrStartDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("ProposalStartDate", getProposalStartDate());
        values.put("ProposalVersion", getProposalVersion());
        values.put("ProposalDmndAdjmtFctrStartDate", getProposalDmndAdjmtFctrStartDate());
        values.put("ProposalDmndAdjmtFctrEndDate", getProposalDmndAdjmtFctrEndDate());
        values.put("DemandAdjustmentFactor", getDemandAdjustmentFactor());
        values.put("AverageDailyUsage", getAverageDailyUsage());
        values.put("AdjustedAverageDailyUsage", getAdjustedAverageDailyUsage());
        values.put("AvgDailyUsageUnit", getAvgDailyUsageUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((String) value));
                }
            }
            if( values.containsKey("ProposalDmndAdjmtFctrStartDate") ) {
                final Object value = values.remove("ProposalDmndAdjmtFctrStartDate");
                if( (value == null) || (!value.equals(getProposalDmndAdjmtFctrStartDate())) ) {
                    setProposalDmndAdjmtFctrStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalDmndAdjmtFctrEndDate") ) {
                final Object value = values.remove("ProposalDmndAdjmtFctrEndDate");
                if( (value == null) || (!value.equals(getProposalDmndAdjmtFctrEndDate())) ) {
                    setProposalDmndAdjmtFctrEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DemandAdjustmentFactor") ) {
                final Object value = values.remove("DemandAdjustmentFactor");
                if( (value == null) || (!value.equals(getDemandAdjustmentFactor())) ) {
                    setDemandAdjustmentFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("AverageDailyUsage") ) {
                final Object value = values.remove("AverageDailyUsage");
                if( (value == null) || (!value.equals(getAverageDailyUsage())) ) {
                    setAverageDailyUsage(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdjustedAverageDailyUsage") ) {
                final Object value = values.remove("AdjustedAverageDailyUsage");
                if( (value == null) || (!value.equals(getAdjustedAverageDailyUsage())) ) {
                    setAdjustedAverageDailyUsage(((BigDecimal) value));
                }
            }
            if( values.containsKey("AvgDailyUsageUnit") ) {
                final Object value = values.remove("AvgDailyUsageUnit");
                if( (value == null) || (!value.equals(getAvgDailyUsageUnit())) ) {
                    setAvgDailyUsageUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProposalHdr") ) {
                final Object value = (values).remove("to_ProposalHdr");
                if( value instanceof Map ) {
                    if( toProposalHdr == null ) {
                        toProposalHdr = new ProposalHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProposalHdr.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DemandAdjustmentsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DemandAdjustmentsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DemandAdjustmentsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DemandAdjustmentsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProposalHdr != null ) {
            (values).put("to_ProposalHdr", toProposalHdr);
        }
        return values;
    }

    /**
     * Fetches the <b>ProposalHeader</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProposalHdr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProposalHeader</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader fetchProposalHdr()
    {
        return fetchFieldAsSingle("to_ProposalHdr", ProposalHeader.class);
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property <b>to_ProposalHdr</b> of a queried <b>DemandAdjustments</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProposalHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader getProposalHdrOrFetch()
    {
        if( toProposalHdr == null ) {
            toProposalHdr = fetchProposalHdr();
        }
        return toProposalHdr;
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property for an entity <b>DemandAdjustments</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProposalHdr</b> is already loaded, the result will
     *         contain the <b>ProposalHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProposalHeader> getProposalHdrIfPresent()
    {
        return Option.of(toProposalHdr);
    }

    /**
     * Overwrites the associated <b>ProposalHeader</b> entity for the loaded navigation property <b>to_ProposalHdr</b>.
     *
     * @param value
     *            New <b>ProposalHeader</b> entity.
     */
    public void setProposalHdr( final ProposalHeader value )
    {
        toProposalHdr = value;
    }

    /**
     * Helper class to allow for fluent creation of DemandAdjustments instances.
     *
     */
    public final static class DemandAdjustmentsBuilder
    {

        private ProposalHeader toProposalHdr;

        private DemandAdjustments.DemandAdjustmentsBuilder toProposalHdr( final ProposalHeader value )
        {
            toProposalHdr = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProposalHdr</b> for <b>DemandAdjustments</b> to single <b>ProposalHeader</b>.
         *
         * @param value
         *            The ProposalHeader to build this DemandAdjustments with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DemandAdjustments.DemandAdjustmentsBuilder proposalHdr( final ProposalHeader value )
        {
            return toProposalHdr(value);
        }

    }

}
