/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.LongestPathInBOMField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.LongestPathInBOMOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.LongestPathInBOMSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Longest Path in BOM
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LongestPathInBOMType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LongestPathInBOM extends VdmEntity<LongestPathInBOM>
{

    /**
     * Selector for all available fields of LongestPathInBOM.
     *
     */
    public final static LongestPathInBOMSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> MATERIAL = new LongestPathInBOMField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> PLANT = new LongestPathInBOMField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> MRP_AREA = new LongestPathInBOMField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @return Proposal Validity From Date
     */
    @Key
    @SerializedName( "ProposalStartDate" )
    @JsonProperty( "ProposalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStartDate</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<LocalDateTime> PROPOSAL_START_DATE =
        new LongestPathInBOMField<LocalDateTime>("ProposalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @return Proposal Version
     */
    @Key
    @SerializedName( "ProposalVersion" )
    @JsonProperty( "ProposalVersion" )
    @Nullable
    @ODataField( odataName = "ProposalVersion" )
    private String proposalVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProposalVersion</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> PROPOSAL_VERSION =
        new LongestPathInBOMField<String>("ProposalVersion");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialUUID</b>
     * </p>
     *
     * @return Internal Key for BOMID
     */
    @Key
    @SerializedName( "BillOfMaterialUUID" )
    @JsonProperty( "BillOfMaterialUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialUUID" )
    private UUID billOfMaterialUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialUUID</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<UUID> BILL_OF_MATERIAL_UUID =
        new LongestPathInBOMField<UUID>("BillOfMaterialUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ParentComponent</b>
     * </p>
     *
     * @return Parent BOM Component
     */
    @Key
    @SerializedName( "ParentComponent" )
    @JsonProperty( "ParentComponent" )
    @Nullable
    @ODataField( odataName = "ParentComponent" )
    private String parentComponent;
    /**
     * Use with available fluent helpers to apply the <b>ParentComponent</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> PARENT_COMPONENT =
        new LongestPathInBOMField<String>("ParentComponent");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ParentPlant</b>
     * </p>
     *
     * @return Parent Plant
     */
    @Key
    @SerializedName( "ParentPlant" )
    @JsonProperty( "ParentPlant" )
    @Nullable
    @ODataField( odataName = "ParentPlant" )
    private String parentPlant;
    /**
     * Use with available fluent helpers to apply the <b>ParentPlant</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> PARENT_PLANT = new LongestPathInBOMField<String>("ParentPlant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @return BOM component
     */
    @Key
    @SerializedName( "BillOfMaterialComponent" )
    @JsonProperty( "BillOfMaterialComponent" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialComponent" )
    private String billOfMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialComponent</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> BILL_OF_MATERIAL_COMPONENT =
        new LongestPathInBOMField<String>("BillOfMaterialComponent");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ComponentPlant</b>
     * </p>
     *
     * @return Component Plant
     */
    @Key
    @SerializedName( "ComponentPlant" )
    @JsonProperty( "ComponentPlant" )
    @Nullable
    @ODataField( odataName = "ComponentPlant" )
    private String componentPlant;
    /**
     * Use with available fluent helpers to apply the <b>ComponentPlant</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> COMPONENT_PLANT =
        new LongestPathInBOMField<String>("ComponentPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ParentMRPArea</b>
     * </p>
     *
     * @return Parent MRP Area
     */
    @SerializedName( "ParentMRPArea" )
    @JsonProperty( "ParentMRPArea" )
    @Nullable
    @ODataField( odataName = "ParentMRPArea" )
    private String parentMRPArea;
    /**
     * Use with available fluent helpers to apply the <b>ParentMRPArea</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> PARENT_MRP_AREA =
        new LongestPathInBOMField<String>("ParentMRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ComponentMRPArea</b>
     * </p>
     *
     * @return Component MRP Area
     */
    @SerializedName( "ComponentMRPArea" )
    @JsonProperty( "ComponentMRPArea" )
    @Nullable
    @ODataField( odataName = "ComponentMRPArea" )
    private String componentMRPArea;
    /**
     * Use with available fluent helpers to apply the <b>ComponentMRPArea</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> COMPONENT_MRP_AREA =
        new LongestPathInBOMField<String>("ComponentMRPArea");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentLeadTime</b>
     * </p>
     *
     * @return Individual Lead Time in Days
     */
    @SerializedName( "ComponentLeadTime" )
    @JsonProperty( "ComponentLeadTime" )
    @Nullable
    @ODataField( odataName = "ComponentLeadTime" )
    private BigDecimal componentLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>ComponentLeadTime</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<BigDecimal> COMPONENT_LEAD_TIME =
        new LongestPathInBOMField<BigDecimal>("ComponentLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeCalculationMethod</b>
     * </p>
     *
     * @return Individual Lead Time calculation Method
     */
    @SerializedName( "LeadTimeCalculationMethod" )
    @JsonProperty( "LeadTimeCalculationMethod" )
    @Nullable
    @ODataField( odataName = "LeadTimeCalculationMethod" )
    private String leadTimeCalculationMethod;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeCalculationMethod</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> LEAD_TIME_CALCULATION_METHOD =
        new LongestPathInBOMField<String>("LeadTimeCalculationMethod");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSOS</b>
     * </p>
     *
     * @return Source of Supply
     */
    @SerializedName( "ComponentSOS" )
    @JsonProperty( "ComponentSOS" )
    @Nullable
    @ODataField( odataName = "ComponentSOS" )
    private String componentSOS;
    /**
     * Use with available fluent helpers to apply the <b>ComponentSOS</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> COMPONENT_SOS = new LongestPathInBOMField<String>("ComponentSOS");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSOSType</b>
     * </p>
     *
     * @return Source Type
     */
    @SerializedName( "ComponentSOSType" )
    @JsonProperty( "ComponentSOSType" )
    @Nullable
    @ODataField( odataName = "ComponentSOSType" )
    private String componentSOSType;
    /**
     * Use with available fluent helpers to apply the <b>ComponentSOSType</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> COMPONENT_SOS_TYPE =
        new LongestPathInBOMField<String>("ComponentSOSType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SOSTypeDescription</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SOSTypeDescription" )
    @JsonProperty( "SOSTypeDescription" )
    @Nullable
    @ODataField( odataName = "SOSTypeDescription" )
    private String sOSTypeDescription;
    /**
     * Use with available fluent helpers to apply the <b>SOSTypeDescription</b> field to query operations.
     *
     */
    public final static LongestPathInBOMField<String> SOS_TYPE_DESCRIPTION =
        new LongestPathInBOMField<String>("SOSTypeDescription");
    /**
     * Navigation property <b>to_ProposalHdr</b> for <b>LongestPathInBOM</b> to single <b>ProposalHeader</b>.
     *
     */
    @SerializedName( "to_ProposalHdr" )
    @JsonProperty( "to_ProposalHdr" )
    @ODataField( odataName = "to_ProposalHdr" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProposalHeader toProposalHdr;
    /**
     * Use with available fluent helpers to apply the <b>to_ProposalHdr</b> navigation property to query operations.
     *
     */
    public final static LongestPathInBOMOneToOneLink<ProposalHeader> TO_PROPOSAL_HDR =
        new LongestPathInBOMOneToOneLink<ProposalHeader>("to_ProposalHdr");

    @Nonnull
    @Override
    public Class<LongestPathInBOM> getType()
    {
        return LongestPathInBOM.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDateTime proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialUUID</b>
     * </p>
     *
     * @param billOfMaterialUUID
     *            Internal Key for BOMID
     */
    public void setBillOfMaterialUUID( @Nullable final UUID billOfMaterialUUID )
    {
        rememberChangedField("BillOfMaterialUUID", this.billOfMaterialUUID);
        this.billOfMaterialUUID = billOfMaterialUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ParentComponent</b>
     * </p>
     *
     * @param parentComponent
     *            Parent BOM Component
     */
    public void setParentComponent( @Nullable final String parentComponent )
    {
        rememberChangedField("ParentComponent", this.parentComponent);
        this.parentComponent = parentComponent;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ParentPlant</b>
     * </p>
     *
     * @param parentPlant
     *            Parent Plant
     */
    public void setParentPlant( @Nullable final String parentPlant )
    {
        rememberChangedField("ParentPlant", this.parentPlant);
        this.parentPlant = parentPlant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @param billOfMaterialComponent
     *            BOM component
     */
    public void setBillOfMaterialComponent( @Nullable final String billOfMaterialComponent )
    {
        rememberChangedField("BillOfMaterialComponent", this.billOfMaterialComponent);
        this.billOfMaterialComponent = billOfMaterialComponent;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ComponentPlant</b>
     * </p>
     *
     * @param componentPlant
     *            Component Plant
     */
    public void setComponentPlant( @Nullable final String componentPlant )
    {
        rememberChangedField("ComponentPlant", this.componentPlant);
        this.componentPlant = componentPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ParentMRPArea</b>
     * </p>
     *
     * @param parentMRPArea
     *            Parent MRP Area
     */
    public void setParentMRPArea( @Nullable final String parentMRPArea )
    {
        rememberChangedField("ParentMRPArea", this.parentMRPArea);
        this.parentMRPArea = parentMRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ComponentMRPArea</b>
     * </p>
     *
     * @param componentMRPArea
     *            Component MRP Area
     */
    public void setComponentMRPArea( @Nullable final String componentMRPArea )
    {
        rememberChangedField("ComponentMRPArea", this.componentMRPArea);
        this.componentMRPArea = componentMRPArea;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentLeadTime</b>
     * </p>
     *
     * @param componentLeadTime
     *            Individual Lead Time in Days
     */
    public void setComponentLeadTime( @Nullable final BigDecimal componentLeadTime )
    {
        rememberChangedField("ComponentLeadTime", this.componentLeadTime);
        this.componentLeadTime = componentLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeCalculationMethod</b>
     * </p>
     *
     * @param leadTimeCalculationMethod
     *            Individual Lead Time calculation Method
     */
    public void setLeadTimeCalculationMethod( @Nullable final String leadTimeCalculationMethod )
    {
        rememberChangedField("LeadTimeCalculationMethod", this.leadTimeCalculationMethod);
        this.leadTimeCalculationMethod = leadTimeCalculationMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSOS</b>
     * </p>
     *
     * @param componentSOS
     *            Source of Supply
     */
    public void setComponentSOS( @Nullable final String componentSOS )
    {
        rememberChangedField("ComponentSOS", this.componentSOS);
        this.componentSOS = componentSOS;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSOSType</b>
     * </p>
     *
     * @param componentSOSType
     *            Source Type
     */
    public void setComponentSOSType( @Nullable final String componentSOSType )
    {
        rememberChangedField("ComponentSOSType", this.componentSOSType);
        this.componentSOSType = componentSOSType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SOSTypeDescription</b>
     * </p>
     *
     * @param sOSTypeDescription
     *            Short Text for Fixed Values
     */
    public void setSOSTypeDescription( @Nullable final String sOSTypeDescription )
    {
        rememberChangedField("SOSTypeDescription", this.sOSTypeDescription);
        this.sOSTypeDescription = sOSTypeDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LongestPathInBOM";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("ProposalStartDate", getProposalStartDate());
        result.put("ProposalVersion", getProposalVersion());
        result.put("BillOfMaterialUUID", getBillOfMaterialUUID());
        result.put("ParentComponent", getParentComponent());
        result.put("ParentPlant", getParentPlant());
        result.put("BillOfMaterialComponent", getBillOfMaterialComponent());
        result.put("ComponentPlant", getComponentPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("ProposalStartDate", getProposalStartDate());
        values.put("ProposalVersion", getProposalVersion());
        values.put("BillOfMaterialUUID", getBillOfMaterialUUID());
        values.put("ParentComponent", getParentComponent());
        values.put("ParentPlant", getParentPlant());
        values.put("BillOfMaterialComponent", getBillOfMaterialComponent());
        values.put("ComponentPlant", getComponentPlant());
        values.put("ParentMRPArea", getParentMRPArea());
        values.put("ComponentMRPArea", getComponentMRPArea());
        values.put("ComponentLeadTime", getComponentLeadTime());
        values.put("LeadTimeCalculationMethod", getLeadTimeCalculationMethod());
        values.put("ComponentSOS", getComponentSOS());
        values.put("ComponentSOSType", getComponentSOSType());
        values.put("SOSTypeDescription", getSOSTypeDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialUUID") ) {
                final Object value = values.remove("BillOfMaterialUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialUUID())) ) {
                    setBillOfMaterialUUID(((UUID) value));
                }
            }
            if( values.containsKey("ParentComponent") ) {
                final Object value = values.remove("ParentComponent");
                if( (value == null) || (!value.equals(getParentComponent())) ) {
                    setParentComponent(((String) value));
                }
            }
            if( values.containsKey("ParentPlant") ) {
                final Object value = values.remove("ParentPlant");
                if( (value == null) || (!value.equals(getParentPlant())) ) {
                    setParentPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialComponent") ) {
                final Object value = values.remove("BillOfMaterialComponent");
                if( (value == null) || (!value.equals(getBillOfMaterialComponent())) ) {
                    setBillOfMaterialComponent(((String) value));
                }
            }
            if( values.containsKey("ComponentPlant") ) {
                final Object value = values.remove("ComponentPlant");
                if( (value == null) || (!value.equals(getComponentPlant())) ) {
                    setComponentPlant(((String) value));
                }
            }
            if( values.containsKey("ParentMRPArea") ) {
                final Object value = values.remove("ParentMRPArea");
                if( (value == null) || (!value.equals(getParentMRPArea())) ) {
                    setParentMRPArea(((String) value));
                }
            }
            if( values.containsKey("ComponentMRPArea") ) {
                final Object value = values.remove("ComponentMRPArea");
                if( (value == null) || (!value.equals(getComponentMRPArea())) ) {
                    setComponentMRPArea(((String) value));
                }
            }
            if( values.containsKey("ComponentLeadTime") ) {
                final Object value = values.remove("ComponentLeadTime");
                if( (value == null) || (!value.equals(getComponentLeadTime())) ) {
                    setComponentLeadTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("LeadTimeCalculationMethod") ) {
                final Object value = values.remove("LeadTimeCalculationMethod");
                if( (value == null) || (!value.equals(getLeadTimeCalculationMethod())) ) {
                    setLeadTimeCalculationMethod(((String) value));
                }
            }
            if( values.containsKey("ComponentSOS") ) {
                final Object value = values.remove("ComponentSOS");
                if( (value == null) || (!value.equals(getComponentSOS())) ) {
                    setComponentSOS(((String) value));
                }
            }
            if( values.containsKey("ComponentSOSType") ) {
                final Object value = values.remove("ComponentSOSType");
                if( (value == null) || (!value.equals(getComponentSOSType())) ) {
                    setComponentSOSType(((String) value));
                }
            }
            if( values.containsKey("SOSTypeDescription") ) {
                final Object value = values.remove("SOSTypeDescription");
                if( (value == null) || (!value.equals(getSOSTypeDescription())) ) {
                    setSOSTypeDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProposalHdr") ) {
                final Object value = (values).remove("to_ProposalHdr");
                if( value instanceof Map ) {
                    if( toProposalHdr == null ) {
                        toProposalHdr = new ProposalHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProposalHdr.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LongestPathInBOMField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LongestPathInBOMField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LongestPathInBOMField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LongestPathInBOMField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProposalHdr != null ) {
            (values).put("to_ProposalHdr", toProposalHdr);
        }
        return values;
    }

    /**
     * Fetches the <b>ProposalHeader</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProposalHdr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProposalHeader</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader fetchProposalHdr()
    {
        return fetchFieldAsSingle("to_ProposalHdr", ProposalHeader.class);
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property <b>to_ProposalHdr</b> of a queried <b>LongestPathInBOM</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProposalHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader getProposalHdrOrFetch()
    {
        if( toProposalHdr == null ) {
            toProposalHdr = fetchProposalHdr();
        }
        return toProposalHdr;
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property for an entity <b>LongestPathInBOM</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProposalHdr</b> is already loaded, the result will
     *         contain the <b>ProposalHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProposalHeader> getProposalHdrIfPresent()
    {
        return Option.of(toProposalHdr);
    }

    /**
     * Overwrites the associated <b>ProposalHeader</b> entity for the loaded navigation property <b>to_ProposalHdr</b>.
     *
     * @param value
     *            New <b>ProposalHeader</b> entity.
     */
    public void setProposalHdr( final ProposalHeader value )
    {
        toProposalHdr = value;
    }

    /**
     * Helper class to allow for fluent creation of LongestPathInBOM instances.
     *
     */
    public final static class LongestPathInBOMBuilder
    {

        private ProposalHeader toProposalHdr;

        private LongestPathInBOM.LongestPathInBOMBuilder toProposalHdr( final ProposalHeader value )
        {
            toProposalHdr = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProposalHdr</b> for <b>LongestPathInBOM</b> to single <b>ProposalHeader</b>.
         *
         * @param value
         *            The ProposalHeader to build this LongestPathInBOM with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LongestPathInBOM.LongestPathInBOMBuilder proposalHdr( final ProposalHeader value )
        {
            return toProposalHdr(value);
        }

    }

}
