/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ProposalHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ProposalHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.ProposalHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Buffer Proposal Details
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProposalHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProposalHeader extends VdmEntity<ProposalHeader>
{

    /**
     * Selector for all available fields of ProposalHeader.
     *
     */
    public final static ProposalHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> MATERIAL = new ProposalHeaderField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> PLANT = new ProposalHeaderField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> MRP_AREA = new ProposalHeaderField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @return Proposal Validity From Date
     */
    @Key
    @SerializedName( "ProposalStartDate" )
    @JsonProperty( "ProposalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStartDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<LocalDateTime> PROPOSAL_START_DATE =
        new ProposalHeaderField<LocalDateTime>("ProposalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @return Proposal Version
     */
    @Key
    @SerializedName( "ProposalVersion" )
    @JsonProperty( "ProposalVersion" )
    @Nullable
    @ODataField( odataName = "ProposalVersion" )
    private String proposalVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProposalVersion</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> PROPOSAL_VERSION =
        new ProposalHeaderField<String>("ProposalVersion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalEndDate</b>
     * </p>
     *
     * @return Proposal Valid To Date
     */
    @SerializedName( "ProposalEndDate" )
    @JsonProperty( "ProposalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalEndDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<LocalDateTime> PROPOSAL_END_DATE =
        new ProposalHeaderField<LocalDateTime>("ProposalEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     *
     * @return Proposal Id
     */
    @SerializedName( "StockLevelProposalID" )
    @JsonProperty( "StockLevelProposalID" )
    @Nullable
    @ODataField( odataName = "StockLevelProposalID" )
    private String stockLevelProposalID;
    /**
     * Use with available fluent helpers to apply the <b>StockLevelProposalID</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> STOCK_LEVEL_PROPOSAL_ID =
        new ProposalHeaderField<String>("StockLevelProposalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "ProcurementType" )
    @JsonProperty( "ProcurementType" )
    @Nullable
    @ODataField( odataName = "ProcurementType" )
    private String procurementType;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementType</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> PROCUREMENT_TYPE =
        new ProposalHeaderField<String>("ProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionCode</b>
     * </p>
     *
     * @return Value Indicator
     */
    @SerializedName( "ConsumptionCode" )
    @JsonProperty( "ConsumptionCode" )
    @Nullable
    @ODataField( odataName = "ConsumptionCode" )
    private String consumptionCode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionCode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> CONSUMPTION_CODE =
        new ProposalHeaderField<String>("ConsumptionCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionMode</b>
     * </p>
     *
     * @return Value Mode
     */
    @SerializedName( "ConsumptionMode" )
    @JsonProperty( "ConsumptionMode" )
    @Nullable
    @ODataField( odataName = "ConsumptionMode" )
    private String consumptionMode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> CONSUMPTION_MODE =
        new ProposalHeaderField<String>("ConsumptionMode");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionValue</b>
     * </p>
     *
     * @return The consumptionValue contained in this entity.
     */
    @SerializedName( "ConsumptionValue" )
    @JsonProperty( "ConsumptionValue" )
    @Nullable
    @ODataField( odataName = "ConsumptionValue" )
    private BigDecimal consumptionValue;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionValue</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> CONSUMPTION_VALUE =
        new ProposalHeaderField<BigDecimal>("ConsumptionValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> CURRENCY = new ProposalHeaderField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityCode</b>
     * </p>
     *
     * @return Variability Co-efficient Indicator
     */
    @SerializedName( "VariabilityCode" )
    @JsonProperty( "VariabilityCode" )
    @Nullable
    @ODataField( odataName = "VariabilityCode" )
    private String variabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityCode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> VARIABILITY_CODE =
        new ProposalHeaderField<String>("VariabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityMode</b>
     * </p>
     *
     * @return Variability Mode
     */
    @SerializedName( "VariabilityMode" )
    @JsonProperty( "VariabilityMode" )
    @Nullable
    @ODataField( odataName = "VariabilityMode" )
    private String variabilityMode;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> VARIABILITY_MODE =
        new ProposalHeaderField<String>("VariabilityMode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityQuantity</b>
     * </p>
     *
     * @return Value from XYZ Analysis
     */
    @SerializedName( "VariabilityQuantity" )
    @JsonProperty( "VariabilityQuantity" )
    @Nullable
    @ODataField( odataName = "VariabilityQuantity" )
    private BigDecimal variabilityQuantity;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityQuantity</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> VARIABILITY_QUANTITY =
        new ProposalHeaderField<BigDecimal>("VariabilityQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "VariabilityUnit" )
    @JsonProperty( "VariabilityUnit" )
    @Nullable
    @ODataField( odataName = "VariabilityUnit" )
    private String variabilityUnit;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityUnit</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> VARIABILITY_UNIT =
        new ProposalHeaderField<String>("VariabilityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeCode</b>
     * </p>
     *
     * @return Decoupled Lead Time Indicator
     */
    @SerializedName( "ReplenishmentLeadTimeCode" )
    @JsonProperty( "ReplenishmentLeadTimeCode" )
    @Nullable
    @ODataField( odataName = "ReplenishmentLeadTimeCode" )
    private String replenishmentLeadTimeCode;
    /**
     * Use with available fluent helpers to apply the <b>ReplenishmentLeadTimeCode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> REPLENISHMENT_LEAD_TIME_CODE =
        new ProposalHeaderField<String>("ReplenishmentLeadTimeCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeMode</b>
     * </p>
     *
     * @return Decoupled Lead Time Mode
     */
    @SerializedName( "ReplenishmentLeadTimeMode" )
    @JsonProperty( "ReplenishmentLeadTimeMode" )
    @Nullable
    @ODataField( odataName = "ReplenishmentLeadTimeMode" )
    private String replenishmentLeadTimeMode;
    /**
     * Use with available fluent helpers to apply the <b>ReplenishmentLeadTimeMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> REPLENISHMENT_LEAD_TIME_MODE =
        new ProposalHeaderField<String>("ReplenishmentLeadTimeMode");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeValue</b>
     * </p>
     *
     * @return Value from EFG Analysis
     */
    @SerializedName( "ReplenishmentLeadTimeValue" )
    @JsonProperty( "ReplenishmentLeadTimeValue" )
    @Nullable
    @ODataField( odataName = "ReplenishmentLeadTimeValue" )
    private BigDecimal replenishmentLeadTimeValue;
    /**
     * Use with available fluent helpers to apply the <b>ReplenishmentLeadTimeValue</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> REPLENISHMENT_LEAD_TIME_VALUE =
        new ProposalHeaderField<BigDecimal>("ReplenishmentLeadTimeValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialUUID</b>
     * </p>
     *
     * @return Internal Key for BOMID
     */
    @SerializedName( "BillOfMaterialUUID" )
    @JsonProperty( "BillOfMaterialUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialUUID" )
    private UUID billOfMaterialUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialUUID</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<UUID> BILL_OF_MATERIAL_UUID =
        new ProposalHeaderField<UUID>("BillOfMaterialUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageCode</b>
     * </p>
     *
     * @return BOM Usage Indicator
     */
    @SerializedName( "BOMUsageCode" )
    @JsonProperty( "BOMUsageCode" )
    @Nullable
    @ODataField( odataName = "BOMUsageCode" )
    private String bOMUsageCode;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsageCode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> BOM_USAGE_CODE = new ProposalHeaderField<String>("BOMUsageCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageMode</b>
     * </p>
     *
     * @return BOM Usage Mode
     */
    @SerializedName( "BOMUsageMode" )
    @JsonProperty( "BOMUsageMode" )
    @Nullable
    @ODataField( odataName = "BOMUsageMode" )
    private String bOMUsageMode;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsageMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> BOM_USAGE_MODE = new ProposalHeaderField<String>("BOMUsageMode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageValue</b>
     * </p>
     *
     * @return Value from PQR Analysis
     */
    @SerializedName( "BOMUsageValue" )
    @JsonProperty( "BOMUsageValue" )
    @Nullable
    @ODataField( odataName = "BOMUsageValue" )
    private String bOMUsageValue;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsageValue</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> BOM_USAGE_VALUE = new ProposalHeaderField<String>("BOMUsageValue");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HorizonDaysInPast</b>
     * </p>
     *
     * @return Period for ADU and LeadTime calculation in past days
     */
    @SerializedName( "HorizonDaysInPast" )
    @JsonProperty( "HorizonDaysInPast" )
    @Nullable
    @ODataField( odataName = "HorizonDaysInPast" )
    private String horizonDaysInPast;
    /**
     * Use with available fluent helpers to apply the <b>HorizonDaysInPast</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> HORIZON_DAYS_IN_PAST =
        new ProposalHeaderField<String>("HorizonDaysInPast");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HorizonDaysInFuture</b>
     * </p>
     *
     * @return Period for ADU calculation in future days
     */
    @SerializedName( "HorizonDaysInFuture" )
    @JsonProperty( "HorizonDaysInFuture" )
    @Nullable
    @ODataField( odataName = "HorizonDaysInFuture" )
    private String horizonDaysInFuture;
    /**
     * Use with available fluent helpers to apply the <b>HorizonDaysInFuture</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> HORIZON_DAYS_IN_FUTURE =
        new ProposalHeaderField<String>("HorizonDaysInFuture");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>IndividualLeadTime</b>
     * </p>
     *
     * @return Individual Lead Time in Days
     */
    @SerializedName( "IndividualLeadTime" )
    @JsonProperty( "IndividualLeadTime" )
    @Nullable
    @ODataField( odataName = "IndividualLeadTime" )
    private BigDecimal individualLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>IndividualLeadTime</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> INDIVIDUAL_LEAD_TIME =
        new ProposalHeaderField<BigDecimal>("IndividualLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeCalculationMethod</b>
     * </p>
     *
     * @return Individual Lead Time calculation Method
     */
    @SerializedName( "LeadTimeCalculationMethod" )
    @JsonProperty( "LeadTimeCalculationMethod" )
    @Nullable
    @ODataField( odataName = "LeadTimeCalculationMethod" )
    private String leadTimeCalculationMethod;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeCalculationMethod</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> LEAD_TIME_CALCULATION_METHOD =
        new ProposalHeaderField<String>("LeadTimeCalculationMethod");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DecoupledLeadTime</b>
     * </p>
     *
     * @return Decoupled Lead Time
     */
    @SerializedName( "DecoupledLeadTime" )
    @JsonProperty( "DecoupledLeadTime" )
    @Nullable
    @ODataField( odataName = "DecoupledLeadTime" )
    private BigDecimal decoupledLeadTime;
    /**
     * Use with available fluent helpers to apply the <b>DecoupledLeadTime</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> DECOUPLED_LEAD_TIME =
        new ProposalHeaderField<BigDecimal>("DecoupledLeadTime");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupply</b>
     * </p>
     *
     * @return Source of Supply
     */
    @SerializedName( "SourceOfSupply" )
    @JsonProperty( "SourceOfSupply" )
    @Nullable
    @ODataField( odataName = "SourceOfSupply" )
    private String sourceOfSupply;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupply</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> SOURCE_OF_SUPPLY =
        new ProposalHeaderField<String>("SourceOfSupply");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SOSType</b>
     * </p>
     *
     * @return Source Type
     */
    @SerializedName( "SOSType" )
    @JsonProperty( "SOSType" )
    @Nullable
    @ODataField( odataName = "SOSType" )
    private String sOSType;
    /**
     * Use with available fluent helpers to apply the <b>SOSType</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> SOS_TYPE = new ProposalHeaderField<String>("SOSType");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeFactor</b>
     * </p>
     *
     * @return Decoupled Lead Time Factor
     */
    @SerializedName( "LeadTimeFactor" )
    @JsonProperty( "LeadTimeFactor" )
    @Nullable
    @ODataField( odataName = "LeadTimeFactor" )
    private BigDecimal leadTimeFactor;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeFactor</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> LEAD_TIME_FACTOR =
        new ProposalHeaderField<BigDecimal>("LeadTimeFactor");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityFactor</b>
     * </p>
     *
     * @return Variability Factor
     */
    @SerializedName( "VariabilityFactor" )
    @JsonProperty( "VariabilityFactor" )
    @Nullable
    @ODataField( odataName = "VariabilityFactor" )
    private BigDecimal variabilityFactor;
    /**
     * Use with available fluent helpers to apply the <b>VariabilityFactor</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> VARIABILITY_FACTOR =
        new ProposalHeaderField<BigDecimal>("VariabilityFactor");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalStatus</b>
     * </p>
     *
     * @return Proposal Status
     */
    @SerializedName( "StockLevelProposalStatus" )
    @JsonProperty( "StockLevelProposalStatus" )
    @Nullable
    @ODataField( odataName = "StockLevelProposalStatus" )
    private String stockLevelProposalStatus;
    /**
     * Use with available fluent helpers to apply the <b>StockLevelProposalStatus</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> STOCK_LEVEL_PROPOSAL_STATUS =
        new ProposalHeaderField<String>("StockLevelProposalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunIsSuspended</b>
     * </p>
     *
     * @return Suspend Proposal Indicator
     */
    @SerializedName( "ProposalRunIsSuspended" )
    @JsonProperty( "ProposalRunIsSuspended" )
    @Nullable
    @ODataField( odataName = "ProposalRunIsSuspended" )
    private String proposalRunIsSuspended;
    /**
     * Use with available fluent helpers to apply the <b>ProposalRunIsSuspended</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> PROPOSAL_RUN_IS_SUSPENDED =
        new ProposalHeaderField<String>("ProposalRunIsSuspended");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunSuspendedFromDate</b>
     * </p>
     *
     * @return Proposal Run Suspension Start Date
     */
    @SerializedName( "ProposalRunSuspendedFromDate" )
    @JsonProperty( "ProposalRunSuspendedFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalRunSuspendedFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalRunSuspendedFromDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalRunSuspendedFromDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<LocalDateTime> PROPOSAL_RUN_SUSPENDED_FROM_DATE =
        new ProposalHeaderField<LocalDateTime>("ProposalRunSuspendedFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunSuspendedToDate</b>
     * </p>
     *
     * @return Proposal Run Suspension End Date
     */
    @SerializedName( "ProposalRunSuspendedToDate" )
    @JsonProperty( "ProposalRunSuspendedToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalRunSuspendedToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalRunSuspendedToDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalRunSuspendedToDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<LocalDateTime> PROPOSAL_RUN_SUSPENDED_TO_DATE =
        new ProposalHeaderField<LocalDateTime>("ProposalRunSuspendedToDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProposalMode</b>
     * </p>
     *
     * @return Proposal Mode
     */
    @SerializedName( "ProposalMode" )
    @JsonProperty( "ProposalMode" )
    @Nullable
    @ODataField( odataName = "ProposalMode" )
    private String proposalMode;
    /**
     * Use with available fluent helpers to apply the <b>ProposalMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> PROPOSAL_MODE = new ProposalHeaderField<String>("ProposalMode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStatusChangeDate</b>
     * </p>
     *
     * @return Proposal Status Changed Time
     */
    @SerializedName( "ProposalStatusChangeDate" )
    @JsonProperty( "ProposalStatusChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStatusChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime proposalStatusChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStatusChangeDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<ZonedDateTime> PROPOSAL_STATUS_CHANGE_DATE =
        new ProposalHeaderField<ZonedDateTime>("ProposalStatusChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMinOrderQtyConsidered</b>
     * </p>
     *
     * @return Is Minimum Order Quantity Considered
     */
    @SerializedName( "IsMinOrderQtyConsidered" )
    @JsonProperty( "IsMinOrderQtyConsidered" )
    @Nullable
    @ODataField( odataName = "IsMinOrderQtyConsidered" )
    private String isMinOrderQtyConsidered;
    /**
     * Use with available fluent helpers to apply the <b>IsMinOrderQtyConsidered</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> IS_MIN_ORDER_QTY_CONSIDERED =
        new ProposalHeaderField<String>("IsMinOrderQtyConsidered");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @return Minimum order quantity in base unit of measure
     */
    @SerializedName( "MinimumOrderQuantity" )
    @JsonProperty( "MinimumOrderQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumOrderQuantity" )
    private BigDecimal minimumOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumOrderQuantity</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> MINIMUM_ORDER_QUANTITY =
        new ProposalHeaderField<BigDecimal>("MinimumOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinOrderQtyUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MinOrderQtyUnit" )
    @JsonProperty( "MinOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "MinOrderQtyUnit" )
    private String minOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>MinOrderQtyUnit</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> MIN_ORDER_QTY_UNIT =
        new ProposalHeaderField<String>("MinOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCycle</b>
     * </p>
     *
     * @return Order Cycle in Days
     */
    @SerializedName( "OrderCycle" )
    @JsonProperty( "OrderCycle" )
    @Nullable
    @ODataField( odataName = "OrderCycle" )
    private BigDecimal orderCycle;
    /**
     * Use with available fluent helpers to apply the <b>OrderCycle</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<BigDecimal> ORDER_CYCLE = new ProposalHeaderField<BigDecimal>("OrderCycle");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosionDate</b>
     * </p>
     *
     * @return BOM Explosion Date
     */
    @SerializedName( "BOMExplosionDate" )
    @JsonProperty( "BOMExplosionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BOMExplosionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bOMExplosionDate;
    /**
     * Use with available fluent helpers to apply the <b>BOMExplosionDate</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<LocalDateTime> BOM_EXPLOSION_DATE =
        new ProposalHeaderField<LocalDateTime>("BOMExplosionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<ZonedDateTime> CREATION_DATE_TIME =
        new ProposalHeaderField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ProposalHeaderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AverageDailyUsageMode</b>
     * </p>
     *
     * @return Average Daily Usage Mode
     */
    @SerializedName( "AverageDailyUsageMode" )
    @JsonProperty( "AverageDailyUsageMode" )
    @Nullable
    @ODataField( odataName = "AverageDailyUsageMode" )
    private String averageDailyUsageMode;
    /**
     * Use with available fluent helpers to apply the <b>AverageDailyUsageMode</b> field to query operations.
     *
     */
    public final static ProposalHeaderField<String> AVERAGE_DAILY_USAGE_MODE =
        new ProposalHeaderField<String>("AverageDailyUsageMode");
    /**
     * Navigation property <b>to_ActualStock</b> for <b>ProposalHeader</b> to multiple <b>ActualStock</b>.
     *
     */
    @SerializedName( "to_ActualStock" )
    @JsonProperty( "to_ActualStock" )
    @ODataField( odataName = "to_ActualStock" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ActualStock> toActualStock;
    /**
     * Navigation property <b>to_ProductBufferProposalDemand</b> for <b>ProposalHeader</b> to multiple
     * <b>DemandAdjustments</b>.
     *
     */
    @SerializedName( "to_ProductBufferProposalDemand" )
    @JsonProperty( "to_ProductBufferProposalDemand" )
    @ODataField( odataName = "to_ProductBufferProposalDemand" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DemandAdjustments> toProductBufferProposalDemand;
    /**
     * Navigation property <b>to_ProductBufferProposalZones</b> for <b>ProposalHeader</b> to multiple
     * <b>ZoneAdjustments</b>.
     *
     */
    @SerializedName( "to_ProductBufferProposalZones" )
    @JsonProperty( "to_ProductBufferProposalZones" )
    @ODataField( odataName = "to_ProductBufferProposalZones" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ZoneAdjustments> toProductBufferProposalZones;
    /**
     * Navigation property <b>to_ProductBufPrpslDmndFctr</b> for <b>ProposalHeader</b> to multiple
     * <b>DemandAdjustmentFactors</b>.
     *
     */
    @SerializedName( "to_ProductBufPrpslDmndFctr" )
    @JsonProperty( "to_ProductBufPrpslDmndFctr" )
    @ODataField( odataName = "to_ProductBufPrpslDmndFctr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DemandAdjustmentFactors> toProductBufPrpslDmndFctr;
    /**
     * Navigation property <b>to_PrpslBOM</b> for <b>ProposalHeader</b> to multiple <b>LongestPathInBOM</b>.
     *
     */
    @SerializedName( "to_PrpslBOM" )
    @JsonProperty( "to_PrpslBOM" )
    @ODataField( odataName = "to_PrpslBOM" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LongestPathInBOM> toPrpslBOM;
    /**
     * Use with available fluent helpers to apply the <b>to_ActualStock</b> navigation property to query operations.
     *
     */
    public final static ProposalHeaderLink<ActualStock> TO_ACTUAL_STOCK =
        new ProposalHeaderLink<ActualStock>("to_ActualStock");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductBufferProposalDemand</b> navigation property to query
     * operations.
     *
     */
    public final static ProposalHeaderLink<DemandAdjustments> TO_PRODUCT_BUFFER_PROPOSAL_DEMAND =
        new ProposalHeaderLink<DemandAdjustments>("to_ProductBufferProposalDemand");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductBufferProposalZones</b> navigation property to query
     * operations.
     *
     */
    public final static ProposalHeaderLink<ZoneAdjustments> TO_PRODUCT_BUFFER_PROPOSAL_ZONES =
        new ProposalHeaderLink<ZoneAdjustments>("to_ProductBufferProposalZones");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductBufPrpslDmndFctr</b> navigation property to query
     * operations.
     *
     */
    public final static ProposalHeaderLink<DemandAdjustmentFactors> TO_PRODUCT_BUF_PRPSL_DMND_FCTR =
        new ProposalHeaderLink<DemandAdjustmentFactors>("to_ProductBufPrpslDmndFctr");
    /**
     * Use with available fluent helpers to apply the <b>to_PrpslBOM</b> navigation property to query operations.
     *
     */
    public final static ProposalHeaderLink<LongestPathInBOM> TO_PRPSL_BOM =
        new ProposalHeaderLink<LongestPathInBOM>("to_PrpslBOM");

    @Nonnull
    @Override
    public Class<ProposalHeader> getType()
    {
        return ProposalHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDateTime proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalEndDate</b>
     * </p>
     *
     * @param proposalEndDate
     *            Proposal Valid To Date
     */
    public void setProposalEndDate( @Nullable final LocalDateTime proposalEndDate )
    {
        rememberChangedField("ProposalEndDate", this.proposalEndDate);
        this.proposalEndDate = proposalEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     *
     * @param stockLevelProposalID
     *            Proposal Id
     */
    public void setStockLevelProposalID( @Nullable final String stockLevelProposalID )
    {
        rememberChangedField("StockLevelProposalID", this.stockLevelProposalID);
        this.stockLevelProposalID = stockLevelProposalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementType</b>
     * </p>
     *
     * @param procurementType
     *            Procurement Type
     */
    public void setProcurementType( @Nullable final String procurementType )
    {
        rememberChangedField("ProcurementType", this.procurementType);
        this.procurementType = procurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionCode</b>
     * </p>
     *
     * @param consumptionCode
     *            Value Indicator
     */
    public void setConsumptionCode( @Nullable final String consumptionCode )
    {
        rememberChangedField("ConsumptionCode", this.consumptionCode);
        this.consumptionCode = consumptionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionMode</b>
     * </p>
     *
     * @param consumptionMode
     *            Value Mode
     */
    public void setConsumptionMode( @Nullable final String consumptionMode )
    {
        rememberChangedField("ConsumptionMode", this.consumptionMode);
        this.consumptionMode = consumptionMode;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionValue</b>
     * </p>
     *
     * @param consumptionValue
     *            The consumptionValue to set.
     */
    public void setConsumptionValue( @Nullable final BigDecimal consumptionValue )
    {
        rememberChangedField("ConsumptionValue", this.consumptionValue);
        this.consumptionValue = consumptionValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityCode</b>
     * </p>
     *
     * @param variabilityCode
     *            Variability Co-efficient Indicator
     */
    public void setVariabilityCode( @Nullable final String variabilityCode )
    {
        rememberChangedField("VariabilityCode", this.variabilityCode);
        this.variabilityCode = variabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityMode</b>
     * </p>
     *
     * @param variabilityMode
     *            Variability Mode
     */
    public void setVariabilityMode( @Nullable final String variabilityMode )
    {
        rememberChangedField("VariabilityMode", this.variabilityMode);
        this.variabilityMode = variabilityMode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityQuantity</b>
     * </p>
     *
     * @param variabilityQuantity
     *            Value from XYZ Analysis
     */
    public void setVariabilityQuantity( @Nullable final BigDecimal variabilityQuantity )
    {
        rememberChangedField("VariabilityQuantity", this.variabilityQuantity);
        this.variabilityQuantity = variabilityQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityUnit</b>
     * </p>
     *
     * @param variabilityUnit
     *            Base Unit of Measure
     */
    public void setVariabilityUnit( @Nullable final String variabilityUnit )
    {
        rememberChangedField("VariabilityUnit", this.variabilityUnit);
        this.variabilityUnit = variabilityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeCode</b>
     * </p>
     *
     * @param replenishmentLeadTimeCode
     *            Decoupled Lead Time Indicator
     */
    public void setReplenishmentLeadTimeCode( @Nullable final String replenishmentLeadTimeCode )
    {
        rememberChangedField("ReplenishmentLeadTimeCode", this.replenishmentLeadTimeCode);
        this.replenishmentLeadTimeCode = replenishmentLeadTimeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeMode</b>
     * </p>
     *
     * @param replenishmentLeadTimeMode
     *            Decoupled Lead Time Mode
     */
    public void setReplenishmentLeadTimeMode( @Nullable final String replenishmentLeadTimeMode )
    {
        rememberChangedField("ReplenishmentLeadTimeMode", this.replenishmentLeadTimeMode);
        this.replenishmentLeadTimeMode = replenishmentLeadTimeMode;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReplenishmentLeadTimeValue</b>
     * </p>
     *
     * @param replenishmentLeadTimeValue
     *            Value from EFG Analysis
     */
    public void setReplenishmentLeadTimeValue( @Nullable final BigDecimal replenishmentLeadTimeValue )
    {
        rememberChangedField("ReplenishmentLeadTimeValue", this.replenishmentLeadTimeValue);
        this.replenishmentLeadTimeValue = replenishmentLeadTimeValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialUUID</b>
     * </p>
     *
     * @param billOfMaterialUUID
     *            Internal Key for BOMID
     */
    public void setBillOfMaterialUUID( @Nullable final UUID billOfMaterialUUID )
    {
        rememberChangedField("BillOfMaterialUUID", this.billOfMaterialUUID);
        this.billOfMaterialUUID = billOfMaterialUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageCode</b>
     * </p>
     *
     * @param bOMUsageCode
     *            BOM Usage Indicator
     */
    public void setBOMUsageCode( @Nullable final String bOMUsageCode )
    {
        rememberChangedField("BOMUsageCode", this.bOMUsageCode);
        this.bOMUsageCode = bOMUsageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageMode</b>
     * </p>
     *
     * @param bOMUsageMode
     *            BOM Usage Mode
     */
    public void setBOMUsageMode( @Nullable final String bOMUsageMode )
    {
        rememberChangedField("BOMUsageMode", this.bOMUsageMode);
        this.bOMUsageMode = bOMUsageMode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsageValue</b>
     * </p>
     *
     * @param bOMUsageValue
     *            Value from PQR Analysis
     */
    public void setBOMUsageValue( @Nullable final String bOMUsageValue )
    {
        rememberChangedField("BOMUsageValue", this.bOMUsageValue);
        this.bOMUsageValue = bOMUsageValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HorizonDaysInPast</b>
     * </p>
     *
     * @param horizonDaysInPast
     *            Period for ADU and LeadTime calculation in past days
     */
    public void setHorizonDaysInPast( @Nullable final String horizonDaysInPast )
    {
        rememberChangedField("HorizonDaysInPast", this.horizonDaysInPast);
        this.horizonDaysInPast = horizonDaysInPast;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HorizonDaysInFuture</b>
     * </p>
     *
     * @param horizonDaysInFuture
     *            Period for ADU calculation in future days
     */
    public void setHorizonDaysInFuture( @Nullable final String horizonDaysInFuture )
    {
        rememberChangedField("HorizonDaysInFuture", this.horizonDaysInFuture);
        this.horizonDaysInFuture = horizonDaysInFuture;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>IndividualLeadTime</b>
     * </p>
     *
     * @param individualLeadTime
     *            Individual Lead Time in Days
     */
    public void setIndividualLeadTime( @Nullable final BigDecimal individualLeadTime )
    {
        rememberChangedField("IndividualLeadTime", this.individualLeadTime);
        this.individualLeadTime = individualLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeCalculationMethod</b>
     * </p>
     *
     * @param leadTimeCalculationMethod
     *            Individual Lead Time calculation Method
     */
    public void setLeadTimeCalculationMethod( @Nullable final String leadTimeCalculationMethod )
    {
        rememberChangedField("LeadTimeCalculationMethod", this.leadTimeCalculationMethod);
        this.leadTimeCalculationMethod = leadTimeCalculationMethod;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DecoupledLeadTime</b>
     * </p>
     *
     * @param decoupledLeadTime
     *            Decoupled Lead Time
     */
    public void setDecoupledLeadTime( @Nullable final BigDecimal decoupledLeadTime )
    {
        rememberChangedField("DecoupledLeadTime", this.decoupledLeadTime);
        this.decoupledLeadTime = decoupledLeadTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupply</b>
     * </p>
     *
     * @param sourceOfSupply
     *            Source of Supply
     */
    public void setSourceOfSupply( @Nullable final String sourceOfSupply )
    {
        rememberChangedField("SourceOfSupply", this.sourceOfSupply);
        this.sourceOfSupply = sourceOfSupply;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SOSType</b>
     * </p>
     *
     * @param sOSType
     *            Source Type
     */
    public void setSOSType( @Nullable final String sOSType )
    {
        rememberChangedField("SOSType", this.sOSType);
        this.sOSType = sOSType;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeFactor</b>
     * </p>
     *
     * @param leadTimeFactor
     *            Decoupled Lead Time Factor
     */
    public void setLeadTimeFactor( @Nullable final BigDecimal leadTimeFactor )
    {
        rememberChangedField("LeadTimeFactor", this.leadTimeFactor);
        this.leadTimeFactor = leadTimeFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>VariabilityFactor</b>
     * </p>
     *
     * @param variabilityFactor
     *            Variability Factor
     */
    public void setVariabilityFactor( @Nullable final BigDecimal variabilityFactor )
    {
        rememberChangedField("VariabilityFactor", this.variabilityFactor);
        this.variabilityFactor = variabilityFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalStatus</b>
     * </p>
     *
     * @param stockLevelProposalStatus
     *            Proposal Status
     */
    public void setStockLevelProposalStatus( @Nullable final String stockLevelProposalStatus )
    {
        rememberChangedField("StockLevelProposalStatus", this.stockLevelProposalStatus);
        this.stockLevelProposalStatus = stockLevelProposalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunIsSuspended</b>
     * </p>
     *
     * @param proposalRunIsSuspended
     *            Suspend Proposal Indicator
     */
    public void setProposalRunIsSuspended( @Nullable final String proposalRunIsSuspended )
    {
        rememberChangedField("ProposalRunIsSuspended", this.proposalRunIsSuspended);
        this.proposalRunIsSuspended = proposalRunIsSuspended;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunSuspendedFromDate</b>
     * </p>
     *
     * @param proposalRunSuspendedFromDate
     *            Proposal Run Suspension Start Date
     */
    public void setProposalRunSuspendedFromDate( @Nullable final LocalDateTime proposalRunSuspendedFromDate )
    {
        rememberChangedField("ProposalRunSuspendedFromDate", this.proposalRunSuspendedFromDate);
        this.proposalRunSuspendedFromDate = proposalRunSuspendedFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalRunSuspendedToDate</b>
     * </p>
     *
     * @param proposalRunSuspendedToDate
     *            Proposal Run Suspension End Date
     */
    public void setProposalRunSuspendedToDate( @Nullable final LocalDateTime proposalRunSuspendedToDate )
    {
        rememberChangedField("ProposalRunSuspendedToDate", this.proposalRunSuspendedToDate);
        this.proposalRunSuspendedToDate = proposalRunSuspendedToDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProposalMode</b>
     * </p>
     *
     * @param proposalMode
     *            Proposal Mode
     */
    public void setProposalMode( @Nullable final String proposalMode )
    {
        rememberChangedField("ProposalMode", this.proposalMode);
        this.proposalMode = proposalMode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStatusChangeDate</b>
     * </p>
     *
     * @param proposalStatusChangeDate
     *            Proposal Status Changed Time
     */
    public void setProposalStatusChangeDate( @Nullable final ZonedDateTime proposalStatusChangeDate )
    {
        rememberChangedField("ProposalStatusChangeDate", this.proposalStatusChangeDate);
        this.proposalStatusChangeDate = proposalStatusChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMinOrderQtyConsidered</b>
     * </p>
     *
     * @param isMinOrderQtyConsidered
     *            Is Minimum Order Quantity Considered
     */
    public void setIsMinOrderQtyConsidered( @Nullable final String isMinOrderQtyConsidered )
    {
        rememberChangedField("IsMinOrderQtyConsidered", this.isMinOrderQtyConsidered);
        this.isMinOrderQtyConsidered = isMinOrderQtyConsidered;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumOrderQuantity</b>
     * </p>
     *
     * @param minimumOrderQuantity
     *            Minimum order quantity in base unit of measure
     */
    public void setMinimumOrderQuantity( @Nullable final BigDecimal minimumOrderQuantity )
    {
        rememberChangedField("MinimumOrderQuantity", this.minimumOrderQuantity);
        this.minimumOrderQuantity = minimumOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinOrderQtyUnit</b>
     * </p>
     *
     * @param minOrderQtyUnit
     *            Base Unit of Measure
     */
    public void setMinOrderQtyUnit( @Nullable final String minOrderQtyUnit )
    {
        rememberChangedField("MinOrderQtyUnit", this.minOrderQtyUnit);
        this.minOrderQtyUnit = minOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCycle</b>
     * </p>
     *
     * @param orderCycle
     *            Order Cycle in Days
     */
    public void setOrderCycle( @Nullable final BigDecimal orderCycle )
    {
        rememberChangedField("OrderCycle", this.orderCycle);
        this.orderCycle = orderCycle;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMExplosionDate</b>
     * </p>
     *
     * @param bOMExplosionDate
     *            BOM Explosion Date
     */
    public void setBOMExplosionDate( @Nullable final LocalDateTime bOMExplosionDate )
    {
        rememberChangedField("BOMExplosionDate", this.bOMExplosionDate);
        this.bOMExplosionDate = bOMExplosionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AverageDailyUsageMode</b>
     * </p>
     *
     * @param averageDailyUsageMode
     *            Average Daily Usage Mode
     */
    public void setAverageDailyUsageMode( @Nullable final String averageDailyUsageMode )
    {
        rememberChangedField("AverageDailyUsageMode", this.averageDailyUsageMode);
        this.averageDailyUsageMode = averageDailyUsageMode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProposalHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("ProposalStartDate", getProposalStartDate());
        result.put("ProposalVersion", getProposalVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("ProposalStartDate", getProposalStartDate());
        values.put("ProposalVersion", getProposalVersion());
        values.put("ProposalEndDate", getProposalEndDate());
        values.put("StockLevelProposalID", getStockLevelProposalID());
        values.put("ProcurementType", getProcurementType());
        values.put("ConsumptionCode", getConsumptionCode());
        values.put("ConsumptionMode", getConsumptionMode());
        values.put("ConsumptionValue", getConsumptionValue());
        values.put("Currency", getCurrency());
        values.put("VariabilityCode", getVariabilityCode());
        values.put("VariabilityMode", getVariabilityMode());
        values.put("VariabilityQuantity", getVariabilityQuantity());
        values.put("VariabilityUnit", getVariabilityUnit());
        values.put("ReplenishmentLeadTimeCode", getReplenishmentLeadTimeCode());
        values.put("ReplenishmentLeadTimeMode", getReplenishmentLeadTimeMode());
        values.put("ReplenishmentLeadTimeValue", getReplenishmentLeadTimeValue());
        values.put("BillOfMaterialUUID", getBillOfMaterialUUID());
        values.put("BOMUsageCode", getBOMUsageCode());
        values.put("BOMUsageMode", getBOMUsageMode());
        values.put("BOMUsageValue", getBOMUsageValue());
        values.put("HorizonDaysInPast", getHorizonDaysInPast());
        values.put("HorizonDaysInFuture", getHorizonDaysInFuture());
        values.put("IndividualLeadTime", getIndividualLeadTime());
        values.put("LeadTimeCalculationMethod", getLeadTimeCalculationMethod());
        values.put("DecoupledLeadTime", getDecoupledLeadTime());
        values.put("SourceOfSupply", getSourceOfSupply());
        values.put("SOSType", getSOSType());
        values.put("LeadTimeFactor", getLeadTimeFactor());
        values.put("VariabilityFactor", getVariabilityFactor());
        values.put("StockLevelProposalStatus", getStockLevelProposalStatus());
        values.put("ProposalRunIsSuspended", getProposalRunIsSuspended());
        values.put("ProposalRunSuspendedFromDate", getProposalRunSuspendedFromDate());
        values.put("ProposalRunSuspendedToDate", getProposalRunSuspendedToDate());
        values.put("ProposalMode", getProposalMode());
        values.put("ProposalStatusChangeDate", getProposalStatusChangeDate());
        values.put("IsMinOrderQtyConsidered", getIsMinOrderQtyConsidered());
        values.put("MinimumOrderQuantity", getMinimumOrderQuantity());
        values.put("MinOrderQtyUnit", getMinOrderQtyUnit());
        values.put("OrderCycle", getOrderCycle());
        values.put("BOMExplosionDate", getBOMExplosionDate());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("AverageDailyUsageMode", getAverageDailyUsageMode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((String) value));
                }
            }
            if( values.containsKey("ProposalEndDate") ) {
                final Object value = values.remove("ProposalEndDate");
                if( (value == null) || (!value.equals(getProposalEndDate())) ) {
                    setProposalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StockLevelProposalID") ) {
                final Object value = values.remove("StockLevelProposalID");
                if( (value == null) || (!value.equals(getStockLevelProposalID())) ) {
                    setStockLevelProposalID(((String) value));
                }
            }
            if( values.containsKey("ProcurementType") ) {
                final Object value = values.remove("ProcurementType");
                if( (value == null) || (!value.equals(getProcurementType())) ) {
                    setProcurementType(((String) value));
                }
            }
            if( values.containsKey("ConsumptionCode") ) {
                final Object value = values.remove("ConsumptionCode");
                if( (value == null) || (!value.equals(getConsumptionCode())) ) {
                    setConsumptionCode(((String) value));
                }
            }
            if( values.containsKey("ConsumptionMode") ) {
                final Object value = values.remove("ConsumptionMode");
                if( (value == null) || (!value.equals(getConsumptionMode())) ) {
                    setConsumptionMode(((String) value));
                }
            }
            if( values.containsKey("ConsumptionValue") ) {
                final Object value = values.remove("ConsumptionValue");
                if( (value == null) || (!value.equals(getConsumptionValue())) ) {
                    setConsumptionValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("VariabilityCode") ) {
                final Object value = values.remove("VariabilityCode");
                if( (value == null) || (!value.equals(getVariabilityCode())) ) {
                    setVariabilityCode(((String) value));
                }
            }
            if( values.containsKey("VariabilityMode") ) {
                final Object value = values.remove("VariabilityMode");
                if( (value == null) || (!value.equals(getVariabilityMode())) ) {
                    setVariabilityMode(((String) value));
                }
            }
            if( values.containsKey("VariabilityQuantity") ) {
                final Object value = values.remove("VariabilityQuantity");
                if( (value == null) || (!value.equals(getVariabilityQuantity())) ) {
                    setVariabilityQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("VariabilityUnit") ) {
                final Object value = values.remove("VariabilityUnit");
                if( (value == null) || (!value.equals(getVariabilityUnit())) ) {
                    setVariabilityUnit(((String) value));
                }
            }
            if( values.containsKey("ReplenishmentLeadTimeCode") ) {
                final Object value = values.remove("ReplenishmentLeadTimeCode");
                if( (value == null) || (!value.equals(getReplenishmentLeadTimeCode())) ) {
                    setReplenishmentLeadTimeCode(((String) value));
                }
            }
            if( values.containsKey("ReplenishmentLeadTimeMode") ) {
                final Object value = values.remove("ReplenishmentLeadTimeMode");
                if( (value == null) || (!value.equals(getReplenishmentLeadTimeMode())) ) {
                    setReplenishmentLeadTimeMode(((String) value));
                }
            }
            if( values.containsKey("ReplenishmentLeadTimeValue") ) {
                final Object value = values.remove("ReplenishmentLeadTimeValue");
                if( (value == null) || (!value.equals(getReplenishmentLeadTimeValue())) ) {
                    setReplenishmentLeadTimeValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfMaterialUUID") ) {
                final Object value = values.remove("BillOfMaterialUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialUUID())) ) {
                    setBillOfMaterialUUID(((UUID) value));
                }
            }
            if( values.containsKey("BOMUsageCode") ) {
                final Object value = values.remove("BOMUsageCode");
                if( (value == null) || (!value.equals(getBOMUsageCode())) ) {
                    setBOMUsageCode(((String) value));
                }
            }
            if( values.containsKey("BOMUsageMode") ) {
                final Object value = values.remove("BOMUsageMode");
                if( (value == null) || (!value.equals(getBOMUsageMode())) ) {
                    setBOMUsageMode(((String) value));
                }
            }
            if( values.containsKey("BOMUsageValue") ) {
                final Object value = values.remove("BOMUsageValue");
                if( (value == null) || (!value.equals(getBOMUsageValue())) ) {
                    setBOMUsageValue(((String) value));
                }
            }
            if( values.containsKey("HorizonDaysInPast") ) {
                final Object value = values.remove("HorizonDaysInPast");
                if( (value == null) || (!value.equals(getHorizonDaysInPast())) ) {
                    setHorizonDaysInPast(((String) value));
                }
            }
            if( values.containsKey("HorizonDaysInFuture") ) {
                final Object value = values.remove("HorizonDaysInFuture");
                if( (value == null) || (!value.equals(getHorizonDaysInFuture())) ) {
                    setHorizonDaysInFuture(((String) value));
                }
            }
            if( values.containsKey("IndividualLeadTime") ) {
                final Object value = values.remove("IndividualLeadTime");
                if( (value == null) || (!value.equals(getIndividualLeadTime())) ) {
                    setIndividualLeadTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("LeadTimeCalculationMethod") ) {
                final Object value = values.remove("LeadTimeCalculationMethod");
                if( (value == null) || (!value.equals(getLeadTimeCalculationMethod())) ) {
                    setLeadTimeCalculationMethod(((String) value));
                }
            }
            if( values.containsKey("DecoupledLeadTime") ) {
                final Object value = values.remove("DecoupledLeadTime");
                if( (value == null) || (!value.equals(getDecoupledLeadTime())) ) {
                    setDecoupledLeadTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("SourceOfSupply") ) {
                final Object value = values.remove("SourceOfSupply");
                if( (value == null) || (!value.equals(getSourceOfSupply())) ) {
                    setSourceOfSupply(((String) value));
                }
            }
            if( values.containsKey("SOSType") ) {
                final Object value = values.remove("SOSType");
                if( (value == null) || (!value.equals(getSOSType())) ) {
                    setSOSType(((String) value));
                }
            }
            if( values.containsKey("LeadTimeFactor") ) {
                final Object value = values.remove("LeadTimeFactor");
                if( (value == null) || (!value.equals(getLeadTimeFactor())) ) {
                    setLeadTimeFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("VariabilityFactor") ) {
                final Object value = values.remove("VariabilityFactor");
                if( (value == null) || (!value.equals(getVariabilityFactor())) ) {
                    setVariabilityFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("StockLevelProposalStatus") ) {
                final Object value = values.remove("StockLevelProposalStatus");
                if( (value == null) || (!value.equals(getStockLevelProposalStatus())) ) {
                    setStockLevelProposalStatus(((String) value));
                }
            }
            if( values.containsKey("ProposalRunIsSuspended") ) {
                final Object value = values.remove("ProposalRunIsSuspended");
                if( (value == null) || (!value.equals(getProposalRunIsSuspended())) ) {
                    setProposalRunIsSuspended(((String) value));
                }
            }
            if( values.containsKey("ProposalRunSuspendedFromDate") ) {
                final Object value = values.remove("ProposalRunSuspendedFromDate");
                if( (value == null) || (!value.equals(getProposalRunSuspendedFromDate())) ) {
                    setProposalRunSuspendedFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalRunSuspendedToDate") ) {
                final Object value = values.remove("ProposalRunSuspendedToDate");
                if( (value == null) || (!value.equals(getProposalRunSuspendedToDate())) ) {
                    setProposalRunSuspendedToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalMode") ) {
                final Object value = values.remove("ProposalMode");
                if( (value == null) || (!value.equals(getProposalMode())) ) {
                    setProposalMode(((String) value));
                }
            }
            if( values.containsKey("ProposalStatusChangeDate") ) {
                final Object value = values.remove("ProposalStatusChangeDate");
                if( (value == null) || (!value.equals(getProposalStatusChangeDate())) ) {
                    setProposalStatusChangeDate(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IsMinOrderQtyConsidered") ) {
                final Object value = values.remove("IsMinOrderQtyConsidered");
                if( (value == null) || (!value.equals(getIsMinOrderQtyConsidered())) ) {
                    setIsMinOrderQtyConsidered(((String) value));
                }
            }
            if( values.containsKey("MinimumOrderQuantity") ) {
                final Object value = values.remove("MinimumOrderQuantity");
                if( (value == null) || (!value.equals(getMinimumOrderQuantity())) ) {
                    setMinimumOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MinOrderQtyUnit") ) {
                final Object value = values.remove("MinOrderQtyUnit");
                if( (value == null) || (!value.equals(getMinOrderQtyUnit())) ) {
                    setMinOrderQtyUnit(((String) value));
                }
            }
            if( values.containsKey("OrderCycle") ) {
                final Object value = values.remove("OrderCycle");
                if( (value == null) || (!value.equals(getOrderCycle())) ) {
                    setOrderCycle(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMExplosionDate") ) {
                final Object value = values.remove("BOMExplosionDate");
                if( (value == null) || (!value.equals(getBOMExplosionDate())) ) {
                    setBOMExplosionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("AverageDailyUsageMode") ) {
                final Object value = values.remove("AverageDailyUsageMode");
                if( (value == null) || (!value.equals(getAverageDailyUsageMode())) ) {
                    setAverageDailyUsageMode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ActualStock") ) {
                final Object value = (values).remove("to_ActualStock");
                if( value instanceof Iterable ) {
                    if( toActualStock == null ) {
                        toActualStock = Lists.newArrayList();
                    } else {
                        toActualStock = Lists.newArrayList(toActualStock);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ActualStock entity;
                        if( toActualStock.size() > i ) {
                            entity = toActualStock.get(i);
                        } else {
                            entity = new ActualStock();
                            toActualStock.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductBufferProposalDemand") ) {
                final Object value = (values).remove("to_ProductBufferProposalDemand");
                if( value instanceof Iterable ) {
                    if( toProductBufferProposalDemand == null ) {
                        toProductBufferProposalDemand = Lists.newArrayList();
                    } else {
                        toProductBufferProposalDemand = Lists.newArrayList(toProductBufferProposalDemand);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DemandAdjustments entity;
                        if( toProductBufferProposalDemand.size() > i ) {
                            entity = toProductBufferProposalDemand.get(i);
                        } else {
                            entity = new DemandAdjustments();
                            toProductBufferProposalDemand.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductBufferProposalZones") ) {
                final Object value = (values).remove("to_ProductBufferProposalZones");
                if( value instanceof Iterable ) {
                    if( toProductBufferProposalZones == null ) {
                        toProductBufferProposalZones = Lists.newArrayList();
                    } else {
                        toProductBufferProposalZones = Lists.newArrayList(toProductBufferProposalZones);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ZoneAdjustments entity;
                        if( toProductBufferProposalZones.size() > i ) {
                            entity = toProductBufferProposalZones.get(i);
                        } else {
                            entity = new ZoneAdjustments();
                            toProductBufferProposalZones.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductBufPrpslDmndFctr") ) {
                final Object value = (values).remove("to_ProductBufPrpslDmndFctr");
                if( value instanceof Iterable ) {
                    if( toProductBufPrpslDmndFctr == null ) {
                        toProductBufPrpslDmndFctr = Lists.newArrayList();
                    } else {
                        toProductBufPrpslDmndFctr = Lists.newArrayList(toProductBufPrpslDmndFctr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DemandAdjustmentFactors entity;
                        if( toProductBufPrpslDmndFctr.size() > i ) {
                            entity = toProductBufPrpslDmndFctr.get(i);
                        } else {
                            entity = new DemandAdjustmentFactors();
                            toProductBufPrpslDmndFctr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PrpslBOM") ) {
                final Object value = (values).remove("to_PrpslBOM");
                if( value instanceof Iterable ) {
                    if( toPrpslBOM == null ) {
                        toPrpslBOM = Lists.newArrayList();
                    } else {
                        toPrpslBOM = Lists.newArrayList(toPrpslBOM);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LongestPathInBOM entity;
                        if( toPrpslBOM.size() > i ) {
                            entity = toPrpslBOM.get(i);
                        } else {
                            entity = new LongestPathInBOM();
                            toPrpslBOM.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProposalHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProposalHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProposalHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProposalHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toActualStock != null ) {
            (values).put("to_ActualStock", toActualStock);
        }
        if( toProductBufferProposalDemand != null ) {
            (values).put("to_ProductBufferProposalDemand", toProductBufferProposalDemand);
        }
        if( toProductBufferProposalZones != null ) {
            (values).put("to_ProductBufferProposalZones", toProductBufferProposalZones);
        }
        if( toProductBufPrpslDmndFctr != null ) {
            (values).put("to_ProductBufPrpslDmndFctr", toProductBufPrpslDmndFctr);
        }
        if( toPrpslBOM != null ) {
            (values).put("to_PrpslBOM", toPrpslBOM);
        }
        return values;
    }

    /**
     * Fetches the <b>ActualStock</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ActualStock</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ActualStock</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ActualStock> fetchActualStock()
    {
        return fetchFieldAsList("to_ActualStock", ActualStock.class);
    }

    /**
     * Retrieval of associated <b>ActualStock</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ActualStock</b>.
     * <p>
     * If the navigation property <b>to_ActualStock</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ActualStock</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ActualStock> getActualStockOrFetch()
    {
        if( toActualStock == null ) {
            toActualStock = fetchActualStock();
        }
        return toActualStock;
    }

    /**
     * Retrieval of associated <b>ActualStock</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ActualStock</b>.
     * <p>
     * If the navigation property for an entity <b>ProposalHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ActualStock</b> is already loaded, the result will
     *         contain the <b>ActualStock</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ActualStock>> getActualStockIfPresent()
    {
        return Option.of(toActualStock);
    }

    /**
     * Overwrites the list of associated <b>ActualStock</b> entities for the loaded navigation property
     * <b>to_ActualStock</b>.
     * <p>
     * If the navigation property <b>to_ActualStock</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ActualStock</b> entities.
     */
    public void setActualStock( @Nonnull final List<ActualStock> value )
    {
        if( toActualStock == null ) {
            toActualStock = Lists.newArrayList();
        }
        toActualStock.clear();
        toActualStock.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ActualStock</b> entities. This corresponds to the OData navigation
     * property <b>to_ActualStock</b>.
     * <p>
     * If the navigation property <b>to_ActualStock</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ActualStock</b> entities.
     */
    public void addActualStock( ActualStock... entity )
    {
        if( toActualStock == null ) {
            toActualStock = Lists.newArrayList();
        }
        toActualStock.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DemandAdjustments</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProductBufferProposalDemand</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DemandAdjustments</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DemandAdjustments> fetchProductBufferProposalDemand()
    {
        return fetchFieldAsList("to_ProductBufferProposalDemand", DemandAdjustments.class);
    }

    /**
     * Retrieval of associated <b>DemandAdjustments</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductBufferProposalDemand</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalDemand</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DemandAdjustments</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DemandAdjustments> getProductBufferProposalDemandOrFetch()
    {
        if( toProductBufferProposalDemand == null ) {
            toProductBufferProposalDemand = fetchProductBufferProposalDemand();
        }
        return toProductBufferProposalDemand;
    }

    /**
     * Retrieval of associated <b>DemandAdjustments</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductBufferProposalDemand</b>.
     * <p>
     * If the navigation property for an entity <b>ProposalHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductBufferProposalDemand</b> is already loaded, the
     *         result will contain the <b>DemandAdjustments</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DemandAdjustments>> getProductBufferProposalDemandIfPresent()
    {
        return Option.of(toProductBufferProposalDemand);
    }

    /**
     * Overwrites the list of associated <b>DemandAdjustments</b> entities for the loaded navigation property
     * <b>to_ProductBufferProposalDemand</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalDemand</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DemandAdjustments</b> entities.
     */
    public void setProductBufferProposalDemand( @Nonnull final List<DemandAdjustments> value )
    {
        if( toProductBufferProposalDemand == null ) {
            toProductBufferProposalDemand = Lists.newArrayList();
        }
        toProductBufferProposalDemand.clear();
        toProductBufferProposalDemand.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DemandAdjustments</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductBufferProposalDemand</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalDemand</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DemandAdjustments</b> entities.
     */
    public void addProductBufferProposalDemand( DemandAdjustments... entity )
    {
        if( toProductBufferProposalDemand == null ) {
            toProductBufferProposalDemand = Lists.newArrayList();
        }
        toProductBufferProposalDemand.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ZoneAdjustments</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProductBufferProposalZones</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ZoneAdjustments</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ZoneAdjustments> fetchProductBufferProposalZones()
    {
        return fetchFieldAsList("to_ProductBufferProposalZones", ZoneAdjustments.class);
    }

    /**
     * Retrieval of associated <b>ZoneAdjustments</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductBufferProposalZones</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalZones</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ZoneAdjustments</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ZoneAdjustments> getProductBufferProposalZonesOrFetch()
    {
        if( toProductBufferProposalZones == null ) {
            toProductBufferProposalZones = fetchProductBufferProposalZones();
        }
        return toProductBufferProposalZones;
    }

    /**
     * Retrieval of associated <b>ZoneAdjustments</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProductBufferProposalZones</b>.
     * <p>
     * If the navigation property for an entity <b>ProposalHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductBufferProposalZones</b> is already loaded, the
     *         result will contain the <b>ZoneAdjustments</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ZoneAdjustments>> getProductBufferProposalZonesIfPresent()
    {
        return Option.of(toProductBufferProposalZones);
    }

    /**
     * Overwrites the list of associated <b>ZoneAdjustments</b> entities for the loaded navigation property
     * <b>to_ProductBufferProposalZones</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalZones</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ZoneAdjustments</b> entities.
     */
    public void setProductBufferProposalZones( @Nonnull final List<ZoneAdjustments> value )
    {
        if( toProductBufferProposalZones == null ) {
            toProductBufferProposalZones = Lists.newArrayList();
        }
        toProductBufferProposalZones.clear();
        toProductBufferProposalZones.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ZoneAdjustments</b> entities. This corresponds to the OData navigation
     * property <b>to_ProductBufferProposalZones</b>.
     * <p>
     * If the navigation property <b>to_ProductBufferProposalZones</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ZoneAdjustments</b> entities.
     */
    public void addProductBufferProposalZones( ZoneAdjustments... entity )
    {
        if( toProductBufferProposalZones == null ) {
            toProductBufferProposalZones = Lists.newArrayList();
        }
        toProductBufferProposalZones.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DemandAdjustmentFactors</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProductBufPrpslDmndFctr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DemandAdjustmentFactors</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DemandAdjustmentFactors> fetchProductBufPrpslDmndFctr()
    {
        return fetchFieldAsList("to_ProductBufPrpslDmndFctr", DemandAdjustmentFactors.class);
    }

    /**
     * Retrieval of associated <b>DemandAdjustmentFactors</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductBufPrpslDmndFctr</b>.
     * <p>
     * If the navigation property <b>to_ProductBufPrpslDmndFctr</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DemandAdjustmentFactors</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DemandAdjustmentFactors> getProductBufPrpslDmndFctrOrFetch()
    {
        if( toProductBufPrpslDmndFctr == null ) {
            toProductBufPrpslDmndFctr = fetchProductBufPrpslDmndFctr();
        }
        return toProductBufPrpslDmndFctr;
    }

    /**
     * Retrieval of associated <b>DemandAdjustmentFactors</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductBufPrpslDmndFctr</b>.
     * <p>
     * If the navigation property for an entity <b>ProposalHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductBufPrpslDmndFctr</b> is already loaded, the
     *         result will contain the <b>DemandAdjustmentFactors</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DemandAdjustmentFactors>> getProductBufPrpslDmndFctrIfPresent()
    {
        return Option.of(toProductBufPrpslDmndFctr);
    }

    /**
     * Overwrites the list of associated <b>DemandAdjustmentFactors</b> entities for the loaded navigation property
     * <b>to_ProductBufPrpslDmndFctr</b>.
     * <p>
     * If the navigation property <b>to_ProductBufPrpslDmndFctr</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DemandAdjustmentFactors</b> entities.
     */
    public void setProductBufPrpslDmndFctr( @Nonnull final List<DemandAdjustmentFactors> value )
    {
        if( toProductBufPrpslDmndFctr == null ) {
            toProductBufPrpslDmndFctr = Lists.newArrayList();
        }
        toProductBufPrpslDmndFctr.clear();
        toProductBufPrpslDmndFctr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DemandAdjustmentFactors</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductBufPrpslDmndFctr</b>.
     * <p>
     * If the navigation property <b>to_ProductBufPrpslDmndFctr</b> of a queried <b>ProposalHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DemandAdjustmentFactors</b> entities.
     */
    public void addProductBufPrpslDmndFctr( DemandAdjustmentFactors... entity )
    {
        if( toProductBufPrpslDmndFctr == null ) {
            toProductBufPrpslDmndFctr = Lists.newArrayList();
        }
        toProductBufPrpslDmndFctr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LongestPathInBOM</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PrpslBOM</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LongestPathInBOM</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LongestPathInBOM> fetchPrpslBOM()
    {
        return fetchFieldAsList("to_PrpslBOM", LongestPathInBOM.class);
    }

    /**
     * Retrieval of associated <b>LongestPathInBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PrpslBOM</b>.
     * <p>
     * If the navigation property <b>to_PrpslBOM</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LongestPathInBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LongestPathInBOM> getPrpslBOMOrFetch()
    {
        if( toPrpslBOM == null ) {
            toPrpslBOM = fetchPrpslBOM();
        }
        return toPrpslBOM;
    }

    /**
     * Retrieval of associated <b>LongestPathInBOM</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PrpslBOM</b>.
     * <p>
     * If the navigation property for an entity <b>ProposalHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PrpslBOM</b> is already loaded, the result will contain
     *         the <b>LongestPathInBOM</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<LongestPathInBOM>> getPrpslBOMIfPresent()
    {
        return Option.of(toPrpslBOM);
    }

    /**
     * Overwrites the list of associated <b>LongestPathInBOM</b> entities for the loaded navigation property
     * <b>to_PrpslBOM</b>.
     * <p>
     * If the navigation property <b>to_PrpslBOM</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LongestPathInBOM</b> entities.
     */
    public void setPrpslBOM( @Nonnull final List<LongestPathInBOM> value )
    {
        if( toPrpslBOM == null ) {
            toPrpslBOM = Lists.newArrayList();
        }
        toPrpslBOM.clear();
        toPrpslBOM.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LongestPathInBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_PrpslBOM</b>.
     * <p>
     * If the navigation property <b>to_PrpslBOM</b> of a queried <b>ProposalHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LongestPathInBOM</b> entities.
     */
    public void addPrpslBOM( LongestPathInBOM... entity )
    {
        if( toPrpslBOM == null ) {
            toPrpslBOM = Lists.newArrayList();
        }
        toPrpslBOM.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProposalHeader instances.
     *
     */
    public final static class ProposalHeaderBuilder
    {

        private List<ActualStock> toActualStock = Lists.newArrayList();
        private List<DemandAdjustments> toProductBufferProposalDemand = Lists.newArrayList();
        private List<ZoneAdjustments> toProductBufferProposalZones = Lists.newArrayList();
        private List<DemandAdjustmentFactors> toProductBufPrpslDmndFctr = Lists.newArrayList();
        private List<LongestPathInBOM> toPrpslBOM = Lists.newArrayList();

        private ProposalHeader.ProposalHeaderBuilder toActualStock( final List<ActualStock> value )
        {
            toActualStock.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ActualStock</b> for <b>ProposalHeader</b> to multiple <b>ActualStock</b>.
         *
         * @param value
         *            The ActualStocks to build this ProposalHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProposalHeader.ProposalHeaderBuilder actualStock( ActualStock... value )
        {
            return toActualStock(Lists.newArrayList(value));
        }

        private ProposalHeader.ProposalHeaderBuilder toProductBufferProposalDemand(
            final List<DemandAdjustments> value )
        {
            toProductBufferProposalDemand.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductBufferProposalDemand</b> for <b>ProposalHeader</b> to multiple
         * <b>DemandAdjustments</b>.
         *
         * @param value
         *            The DemandAdjustmentss to build this ProposalHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProposalHeader.ProposalHeaderBuilder productBufferProposalDemand( DemandAdjustments... value )
        {
            return toProductBufferProposalDemand(Lists.newArrayList(value));
        }

        private ProposalHeader.ProposalHeaderBuilder toProductBufferProposalZones( final List<ZoneAdjustments> value )
        {
            toProductBufferProposalZones.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductBufferProposalZones</b> for <b>ProposalHeader</b> to multiple
         * <b>ZoneAdjustments</b>.
         *
         * @param value
         *            The ZoneAdjustmentss to build this ProposalHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProposalHeader.ProposalHeaderBuilder productBufferProposalZones( ZoneAdjustments... value )
        {
            return toProductBufferProposalZones(Lists.newArrayList(value));
        }

        private ProposalHeader.ProposalHeaderBuilder toProductBufPrpslDmndFctr(
            final List<DemandAdjustmentFactors> value )
        {
            toProductBufPrpslDmndFctr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductBufPrpslDmndFctr</b> for <b>ProposalHeader</b> to multiple
         * <b>DemandAdjustmentFactors</b>.
         *
         * @param value
         *            The DemandAdjustmentFactorss to build this ProposalHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProposalHeader.ProposalHeaderBuilder productBufPrpslDmndFctr( DemandAdjustmentFactors... value )
        {
            return toProductBufPrpslDmndFctr(Lists.newArrayList(value));
        }

        private ProposalHeader.ProposalHeaderBuilder toPrpslBOM( final List<LongestPathInBOM> value )
        {
            toPrpslBOM.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PrpslBOM</b> for <b>ProposalHeader</b> to multiple <b>LongestPathInBOM</b>.
         *
         * @param value
         *            The LongestPathInBOMs to build this ProposalHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProposalHeader.ProposalHeaderBuilder prpslBOM( LongestPathInBOM... value )
        {
            return toPrpslBOM(Lists.newArrayList(value));
        }

    }

}
