/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ZoneAdjustmentsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ZoneAdjustmentsOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.ZoneAdjustmentsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Zone Adjustments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ZoneAdjustmentsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ZoneAdjustments extends VdmEntity<ZoneAdjustments>
{

    /**
     * Selector for all available fields of ZoneAdjustments.
     *
     */
    public final static ZoneAdjustmentsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<String> MATERIAL = new ZoneAdjustmentsField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<String> PLANT = new ZoneAdjustmentsField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<String> MRP_AREA = new ZoneAdjustmentsField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @return Proposal Validity From Date
     */
    @Key
    @SerializedName( "ProposalStartDate" )
    @JsonProperty( "ProposalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProposalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProposalStartDate</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<LocalDateTime> PROPOSAL_START_DATE =
        new ZoneAdjustmentsField<LocalDateTime>("ProposalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @return Proposal Version
     */
    @Key
    @SerializedName( "ProposalVersion" )
    @JsonProperty( "ProposalVersion" )
    @Nullable
    @ODataField( odataName = "ProposalVersion" )
    private String proposalVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProposalVersion</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<String> PROPOSAL_VERSION =
        new ZoneAdjustmentsField<String>("ProposalVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufPrpslZoneAdjmtFctrStartDate</b>
     * </p>
     *
     * @return Proposal Zones Valid From
     */
    @Key
    @SerializedName( "BufPrpslZoneAdjmtFctrStartDate" )
    @JsonProperty( "BufPrpslZoneAdjmtFctrStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BufPrpslZoneAdjmtFctrStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bufPrpslZoneAdjmtFctrStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BufPrpslZoneAdjmtFctrStartDate</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<LocalDateTime> BUF_PRPSL_ZONE_ADJMT_FCTR_START_DATE =
        new ZoneAdjustmentsField<LocalDateTime>("BufPrpslZoneAdjmtFctrStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufPrpslZoneAdjmtFctrEndDate</b>
     * </p>
     *
     * @return Proposal Zones Valid To
     */
    @SerializedName( "BufPrpslZoneAdjmtFctrEndDate" )
    @JsonProperty( "BufPrpslZoneAdjmtFctrEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BufPrpslZoneAdjmtFctrEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bufPrpslZoneAdjmtFctrEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BufPrpslZoneAdjmtFctrEndDate</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<LocalDateTime> BUF_PRPSL_ZONE_ADJMT_FCTR_END_DATE =
        new ZoneAdjustmentsField<LocalDateTime>("BufPrpslZoneAdjmtFctrEndDate");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RedZoneAdjustmentFactor</b>
     * </p>
     *
     * @return Adjustment Factor for Red Zone
     */
    @SerializedName( "RedZoneAdjustmentFactor" )
    @JsonProperty( "RedZoneAdjustmentFactor" )
    @Nullable
    @ODataField( odataName = "RedZoneAdjustmentFactor" )
    private BigDecimal redZoneAdjustmentFactor;
    /**
     * Use with available fluent helpers to apply the <b>RedZoneAdjustmentFactor</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<BigDecimal> RED_ZONE_ADJUSTMENT_FACTOR =
        new ZoneAdjustmentsField<BigDecimal>("RedZoneAdjustmentFactor");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>YellowZoneAdjustmentFactor</b>
     * </p>
     *
     * @return Adjustment Factor for Yellow Zone
     */
    @SerializedName( "YellowZoneAdjustmentFactor" )
    @JsonProperty( "YellowZoneAdjustmentFactor" )
    @Nullable
    @ODataField( odataName = "YellowZoneAdjustmentFactor" )
    private BigDecimal yellowZoneAdjustmentFactor;
    /**
     * Use with available fluent helpers to apply the <b>YellowZoneAdjustmentFactor</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<BigDecimal> YELLOW_ZONE_ADJUSTMENT_FACTOR =
        new ZoneAdjustmentsField<BigDecimal>("YellowZoneAdjustmentFactor");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>GreenZoneAdjustmentFactor</b>
     * </p>
     *
     * @return Adjustment Factor for Green Zone
     */
    @SerializedName( "GreenZoneAdjustmentFactor" )
    @JsonProperty( "GreenZoneAdjustmentFactor" )
    @Nullable
    @ODataField( odataName = "GreenZoneAdjustmentFactor" )
    private BigDecimal greenZoneAdjustmentFactor;
    /**
     * Use with available fluent helpers to apply the <b>GreenZoneAdjustmentFactor</b> field to query operations.
     *
     */
    public final static ZoneAdjustmentsField<BigDecimal> GREEN_ZONE_ADJUSTMENT_FACTOR =
        new ZoneAdjustmentsField<BigDecimal>("GreenZoneAdjustmentFactor");
    /**
     * Navigation property <b>to_ProposalHdr</b> for <b>ZoneAdjustments</b> to single <b>ProposalHeader</b>.
     *
     */
    @SerializedName( "to_ProposalHdr" )
    @JsonProperty( "to_ProposalHdr" )
    @ODataField( odataName = "to_ProposalHdr" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProposalHeader toProposalHdr;
    /**
     * Use with available fluent helpers to apply the <b>to_ProposalHdr</b> navigation property to query operations.
     *
     */
    public final static ZoneAdjustmentsOneToOneLink<ProposalHeader> TO_PROPOSAL_HDR =
        new ZoneAdjustmentsOneToOneLink<ProposalHeader>("to_ProposalHdr");

    @Nonnull
    @Override
    public Class<ZoneAdjustments> getType()
    {
        return ZoneAdjustments.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     *
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDateTime proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     *
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufPrpslZoneAdjmtFctrStartDate</b>
     * </p>
     *
     * @param bufPrpslZoneAdjmtFctrStartDate
     *            Proposal Zones Valid From
     */
    public void setBufPrpslZoneAdjmtFctrStartDate( @Nullable final LocalDateTime bufPrpslZoneAdjmtFctrStartDate )
    {
        rememberChangedField("BufPrpslZoneAdjmtFctrStartDate", this.bufPrpslZoneAdjmtFctrStartDate);
        this.bufPrpslZoneAdjmtFctrStartDate = bufPrpslZoneAdjmtFctrStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BufPrpslZoneAdjmtFctrEndDate</b>
     * </p>
     *
     * @param bufPrpslZoneAdjmtFctrEndDate
     *            Proposal Zones Valid To
     */
    public void setBufPrpslZoneAdjmtFctrEndDate( @Nullable final LocalDateTime bufPrpslZoneAdjmtFctrEndDate )
    {
        rememberChangedField("BufPrpslZoneAdjmtFctrEndDate", this.bufPrpslZoneAdjmtFctrEndDate);
        this.bufPrpslZoneAdjmtFctrEndDate = bufPrpslZoneAdjmtFctrEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RedZoneAdjustmentFactor</b>
     * </p>
     *
     * @param redZoneAdjustmentFactor
     *            Adjustment Factor for Red Zone
     */
    public void setRedZoneAdjustmentFactor( @Nullable final BigDecimal redZoneAdjustmentFactor )
    {
        rememberChangedField("RedZoneAdjustmentFactor", this.redZoneAdjustmentFactor);
        this.redZoneAdjustmentFactor = redZoneAdjustmentFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>YellowZoneAdjustmentFactor</b>
     * </p>
     *
     * @param yellowZoneAdjustmentFactor
     *            Adjustment Factor for Yellow Zone
     */
    public void setYellowZoneAdjustmentFactor( @Nullable final BigDecimal yellowZoneAdjustmentFactor )
    {
        rememberChangedField("YellowZoneAdjustmentFactor", this.yellowZoneAdjustmentFactor);
        this.yellowZoneAdjustmentFactor = yellowZoneAdjustmentFactor;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>GreenZoneAdjustmentFactor</b>
     * </p>
     *
     * @param greenZoneAdjustmentFactor
     *            Adjustment Factor for Green Zone
     */
    public void setGreenZoneAdjustmentFactor( @Nullable final BigDecimal greenZoneAdjustmentFactor )
    {
        rememberChangedField("GreenZoneAdjustmentFactor", this.greenZoneAdjustmentFactor);
        this.greenZoneAdjustmentFactor = greenZoneAdjustmentFactor;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ZoneAdjustments";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("ProposalStartDate", getProposalStartDate());
        result.put("ProposalVersion", getProposalVersion());
        result.put("BufPrpslZoneAdjmtFctrStartDate", getBufPrpslZoneAdjmtFctrStartDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("ProposalStartDate", getProposalStartDate());
        values.put("ProposalVersion", getProposalVersion());
        values.put("BufPrpslZoneAdjmtFctrStartDate", getBufPrpslZoneAdjmtFctrStartDate());
        values.put("BufPrpslZoneAdjmtFctrEndDate", getBufPrpslZoneAdjmtFctrEndDate());
        values.put("RedZoneAdjustmentFactor", getRedZoneAdjustmentFactor());
        values.put("YellowZoneAdjustmentFactor", getYellowZoneAdjustmentFactor());
        values.put("GreenZoneAdjustmentFactor", getGreenZoneAdjustmentFactor());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((String) value));
                }
            }
            if( values.containsKey("BufPrpslZoneAdjmtFctrStartDate") ) {
                final Object value = values.remove("BufPrpslZoneAdjmtFctrStartDate");
                if( (value == null) || (!value.equals(getBufPrpslZoneAdjmtFctrStartDate())) ) {
                    setBufPrpslZoneAdjmtFctrStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BufPrpslZoneAdjmtFctrEndDate") ) {
                final Object value = values.remove("BufPrpslZoneAdjmtFctrEndDate");
                if( (value == null) || (!value.equals(getBufPrpslZoneAdjmtFctrEndDate())) ) {
                    setBufPrpslZoneAdjmtFctrEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RedZoneAdjustmentFactor") ) {
                final Object value = values.remove("RedZoneAdjustmentFactor");
                if( (value == null) || (!value.equals(getRedZoneAdjustmentFactor())) ) {
                    setRedZoneAdjustmentFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("YellowZoneAdjustmentFactor") ) {
                final Object value = values.remove("YellowZoneAdjustmentFactor");
                if( (value == null) || (!value.equals(getYellowZoneAdjustmentFactor())) ) {
                    setYellowZoneAdjustmentFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("GreenZoneAdjustmentFactor") ) {
                final Object value = values.remove("GreenZoneAdjustmentFactor");
                if( (value == null) || (!value.equals(getGreenZoneAdjustmentFactor())) ) {
                    setGreenZoneAdjustmentFactor(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProposalHdr") ) {
                final Object value = (values).remove("to_ProposalHdr");
                if( value instanceof Map ) {
                    if( toProposalHdr == null ) {
                        toProposalHdr = new ProposalHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProposalHdr.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ZoneAdjustmentsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ZoneAdjustmentsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ZoneAdjustmentsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ZoneAdjustmentsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProposalHdr != null ) {
            (values).put("to_ProposalHdr", toProposalHdr);
        }
        return values;
    }

    /**
     * Fetches the <b>ProposalHeader</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProposalHdr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProposalHeader</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader fetchProposalHdr()
    {
        return fetchFieldAsSingle("to_ProposalHdr", ProposalHeader.class);
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property <b>to_ProposalHdr</b> of a queried <b>ZoneAdjustments</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProposalHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProposalHeader getProposalHdrOrFetch()
    {
        if( toProposalHdr == null ) {
            toProposalHdr = fetchProposalHdr();
        }
        return toProposalHdr;
    }

    /**
     * Retrieval of associated <b>ProposalHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProposalHdr</b>.
     * <p>
     * If the navigation property for an entity <b>ZoneAdjustments</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProposalHdr</b> is already loaded, the result will
     *         contain the <b>ProposalHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProposalHeader> getProposalHdrIfPresent()
    {
        return Option.of(toProposalHdr);
    }

    /**
     * Overwrites the associated <b>ProposalHeader</b> entity for the loaded navigation property <b>to_ProposalHdr</b>.
     *
     * @param value
     *            New <b>ProposalHeader</b> entity.
     */
    public void setProposalHdr( final ProposalHeader value )
    {
        toProposalHdr = value;
    }

    /**
     * Helper class to allow for fluent creation of ZoneAdjustments instances.
     *
     */
    public final static class ZoneAdjustmentsBuilder
    {

        private ProposalHeader toProposalHdr;

        private ZoneAdjustments.ZoneAdjustmentsBuilder toProposalHdr( final ProposalHeader value )
        {
            toProposalHdr = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProposalHdr</b> for <b>ZoneAdjustments</b> to single <b>ProposalHeader</b>.
         *
         * @param value
         *            The ProposalHeader to build this ZoneAdjustments with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ZoneAdjustments.ZoneAdjustmentsBuilder proposalHdr( final ProposalHeader value )
        {
            return toProposalHdr(value);
        }

    }

}
