/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService BufferSizingService}.
 *
 */
public interface BufferSizingServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BufferSizingServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BufferSizingServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     * DemandAdjustments} entity and save it to the S/4HANA system.
     *
     * @param demandAdjustments
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments
     *            DemandAdjustments} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BufferSizingServiceBatchChangeSet updateDemandAdjustments( @Nonnull final DemandAdjustments demandAdjustments );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     * DemandAdjustmentFactors} entity and save it to the S/4HANA system.
     *
     * @param demandAdjustmentFactors
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
     *            DemandAdjustmentFactors} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BufferSizingServiceBatchChangeSet
        updateDemandAdjustmentFactors( @Nonnull final DemandAdjustmentFactors demandAdjustmentFactors );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     * ZoneAdjustments} entity and save it to the S/4HANA system.
     *
     * @param zoneAdjustments
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments
     *            ZoneAdjustments} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BufferSizingServiceBatchChangeSet updateZoneAdjustments( @Nonnull final ZoneAdjustments zoneAdjustments );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader
     * ProposalHeader} entity and save it to the S/4HANA system.
     *
     * @param proposalHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BufferSizingServiceBatchChangeSet createProposalHeader( @Nonnull final ProposalHeader proposalHeader );

}
