/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BufferSizingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService BufferSizingService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBufferSizingServiceBatch
    extends
    BatchFluentHelperBasic<BufferSizingServiceBatch, BufferSizingServiceBatchChangeSet>
    implements
    BufferSizingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBufferSizingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBufferSizingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBufferSizingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBufferSizingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBufferSizingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BufferSizingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBufferSizingServiceBatchChangeSet(this, service);
    }

}
