/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments;

/**
 * Implementation of the {@link BufferSizingServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService BufferSizingService}.
 *
 */
public class DefaultBufferSizingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BufferSizingServiceBatch, BufferSizingServiceBatchChangeSet>
    implements
    BufferSizingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService service;

    @SuppressWarnings( "deprecation" )
    DefaultBufferSizingServiceBatchChangeSet(
        @Nonnull final DefaultBufferSizingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BufferSizingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBufferSizingServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BufferSizingServiceBatchChangeSet updateDemandAdjustments(
        @Nonnull final DemandAdjustments demandAdjustments )
    {
        return addRequestUpdate(service::updateDemandAdjustments, demandAdjustments);
    }

    @Nonnull
    @Override
    public BufferSizingServiceBatchChangeSet updateDemandAdjustmentFactors(
        @Nonnull final DemandAdjustmentFactors demandAdjustmentFactors )
    {
        return addRequestUpdate(service::updateDemandAdjustmentFactors, demandAdjustmentFactors);
    }

    @Nonnull
    @Override
    public BufferSizingServiceBatchChangeSet updateZoneAdjustments( @Nonnull final ZoneAdjustments zoneAdjustments )
    {
        return addRequestUpdate(service::updateZoneAdjustments, zoneAdjustments);
    }

    @Nonnull
    @Override
    public BufferSizingServiceBatchChangeSet createProposalHeader( @Nonnull final ProposalHeader proposalHeader )
    {
        return addRequestCreate(service::createProposalHeader, proposalHeader);
    }

}
