/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable.ActualStockSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock} to other entities.
 * Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods to compare
 * a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ActualStockLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ActualStockLink<ObjectT>, ActualStock, ObjectT>
    implements
    ActualStockSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ActualStockLink( final String fieldName )
    {
        super(fieldName);
    }

    private ActualStockLink( final EntityLink<ActualStockLink<ObjectT>, ActualStock, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ActualStockLink<ObjectT> translateLinkType(
        final EntityLink<ActualStockLink<ObjectT>, ActualStock, ObjectT> link )
    {
        return new ActualStockLink<ObjectT>(link);
    }

}
