/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock ActualStock}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ActualStockField
 * ActualStockField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ActualStockLink
 * ActualStockLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#BUFFER_LEVEL_START_DATE
 * BUFFER_LEVEL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#BUFFER_LEVEL_END_DATE
 * BUFFER_LEVEL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#MATERIAL_SAFETY_STOCK_QTY
 * MATERIAL_SAFETY_STOCK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#REORDER_THRESHOLD_QUANTITY
 * REORDER_THRESHOLD_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#MATERIAL_MAX_STOCK_LEVEL_QUANTITY
 * MATERIAL_MAX_STOCK_LEVEL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#CHANGE_MODE CHANGE_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#STOCK_LEVEL_PROPOSAL_ID
 * STOCK_LEVEL_PROPOSAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStock#TO_PROPOSAL_HDR
 * TO_PROPOSAL_HDR}</li>
 * </ul>
 *
 */
public interface ActualStockSelectable extends EntitySelectable<ActualStock>
{

}
