/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors
 * DemandAdjustmentFactors}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.DemandAdjustmentFactorsField
 * DemandAdjustmentFactorsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.DemandAdjustmentFactorsLink
 * DemandAdjustmentFactorsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#PROPOSAL_DMND_ADJMT_FCTR_START_DATE
 * PROPOSAL_DMND_ADJMT_FCTR_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#PROPOSAL_DMND_ADJMT_FCTR_END_DATE
 * PROPOSAL_DMND_ADJMT_FCTR_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#DEMAND_ADJUSTMENT_FACTOR
 * DEMAND_ADJUSTMENT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors#TO_PROPOSAL_HDR
 * TO_PROPOSAL_HDR}</li>
 * </ul>
 *
 */
public interface DemandAdjustmentFactorsSelectable extends EntitySelectable<DemandAdjustmentFactors>
{

}
