/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments DemandAdjustments}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.DemandAdjustmentsField
 * DemandAdjustmentsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.DemandAdjustmentsLink
 * DemandAdjustmentsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#PROPOSAL_DMND_ADJMT_FCTR_START_DATE
 * PROPOSAL_DMND_ADJMT_FCTR_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#PROPOSAL_DMND_ADJMT_FCTR_END_DATE
 * PROPOSAL_DMND_ADJMT_FCTR_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#DEMAND_ADJUSTMENT_FACTOR
 * DEMAND_ADJUSTMENT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#AVERAGE_DAILY_USAGE
 * AVERAGE_DAILY_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#ADJUSTED_AVERAGE_DAILY_USAGE
 * ADJUSTED_AVERAGE_DAILY_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#AVG_DAILY_USAGE_UNIT
 * AVG_DAILY_USAGE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments#TO_PROPOSAL_HDR
 * TO_PROPOSAL_HDR}</li>
 * </ul>
 *
 */
public interface DemandAdjustmentsSelectable extends EntitySelectable<DemandAdjustments>
{

}
