/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM LongestPathInBOM}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.LongestPathInBOMField
 * LongestPathInBOMField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.LongestPathInBOMLink
 * LongestPathInBOMLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#BILL_OF_MATERIAL_UUID
 * BILL_OF_MATERIAL_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PARENT_COMPONENT
 * PARENT_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PARENT_PLANT
 * PARENT_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#BILL_OF_MATERIAL_COMPONENT
 * BILL_OF_MATERIAL_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#COMPONENT_PLANT
 * COMPONENT_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#PARENT_MRP_AREA
 * PARENT_MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#COMPONENT_MRP_AREA
 * COMPONENT_MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#COMPONENT_LEAD_TIME
 * COMPONENT_LEAD_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#LEAD_TIME_CALCULATION_METHOD
 * LEAD_TIME_CALCULATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#COMPONENT_SOS
 * COMPONENT_SOS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#COMPONENT_SOS_TYPE
 * COMPONENT_SOS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#SOS_TYPE_DESCRIPTION
 * SOS_TYPE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOM#TO_PROPOSAL_HDR
 * TO_PROPOSAL_HDR}</li>
 * </ul>
 *
 */
public interface LongestPathInBOMSelectable extends EntitySelectable<LongestPathInBOM>
{

}
