/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader ProposalHeader}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ProposalHeaderField
 * ProposalHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ProposalHeaderLink ProposalHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_END_DATE
 * PROPOSAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#STOCK_LEVEL_PROPOSAL_ID
 * STOCK_LEVEL_PROPOSAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROCUREMENT_TYPE
 * PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#CONSUMPTION_CODE
 * CONSUMPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#CONSUMPTION_MODE
 * CONSUMPTION_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#CONSUMPTION_VALUE
 * CONSUMPTION_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#VARIABILITY_CODE
 * VARIABILITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#VARIABILITY_MODE
 * VARIABILITY_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#VARIABILITY_QUANTITY
 * VARIABILITY_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#VARIABILITY_UNIT
 * VARIABILITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#REPLENISHMENT_LEAD_TIME_CODE
 * REPLENISHMENT_LEAD_TIME_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#REPLENISHMENT_LEAD_TIME_MODE
 * REPLENISHMENT_LEAD_TIME_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#REPLENISHMENT_LEAD_TIME_VALUE
 * REPLENISHMENT_LEAD_TIME_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#BILL_OF_MATERIAL_UUID
 * BILL_OF_MATERIAL_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#BOM_USAGE_CODE
 * BOM_USAGE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#BOM_USAGE_MODE
 * BOM_USAGE_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#BOM_USAGE_VALUE
 * BOM_USAGE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#HORIZON_DAYS_IN_PAST
 * HORIZON_DAYS_IN_PAST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#HORIZON_DAYS_IN_FUTURE
 * HORIZON_DAYS_IN_FUTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#INDIVIDUAL_LEAD_TIME
 * INDIVIDUAL_LEAD_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#LEAD_TIME_CALCULATION_METHOD
 * LEAD_TIME_CALCULATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#DECOUPLED_LEAD_TIME
 * DECOUPLED_LEAD_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#SOURCE_OF_SUPPLY
 * SOURCE_OF_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#SOS_TYPE SOS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#LEAD_TIME_FACTOR
 * LEAD_TIME_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#VARIABILITY_FACTOR
 * VARIABILITY_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#STOCK_LEVEL_PROPOSAL_STATUS
 * STOCK_LEVEL_PROPOSAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_RUN_IS_SUSPENDED
 * PROPOSAL_RUN_IS_SUSPENDED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_RUN_SUSPENDED_FROM_DATE
 * PROPOSAL_RUN_SUSPENDED_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_RUN_SUSPENDED_TO_DATE
 * PROPOSAL_RUN_SUSPENDED_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_MODE
 * PROPOSAL_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#PROPOSAL_STATUS_CHANGE_DATE
 * PROPOSAL_STATUS_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#IS_MIN_ORDER_QTY_CONSIDERED
 * IS_MIN_ORDER_QTY_CONSIDERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#MINIMUM_ORDER_QUANTITY
 * MINIMUM_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#MIN_ORDER_QTY_UNIT
 * MIN_ORDER_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#ORDER_CYCLE
 * ORDER_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#BOM_EXPLOSION_DATE
 * BOM_EXPLOSION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#AVERAGE_DAILY_USAGE_MODE
 * AVERAGE_DAILY_USAGE_MODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#TO_ACTUAL_STOCK
 * TO_ACTUAL_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#TO_PRODUCT_BUFFER_PROPOSAL_DEMAND
 * TO_PRODUCT_BUFFER_PROPOSAL_DEMAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#TO_PRODUCT_BUFFER_PROPOSAL_ZONES
 * TO_PRODUCT_BUFFER_PROPOSAL_ZONES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#TO_PRODUCT_BUF_PRPSL_DMND_FCTR
 * TO_PRODUCT_BUF_PRPSL_DMND_FCTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader#TO_PRPSL_BOM
 * TO_PRPSL_BOM}</li>
 * </ul>
 *
 */
public interface ProposalHeaderSelectable extends EntitySelectable<ProposalHeader>
{

}
