/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments ZoneAdjustments}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.field.ZoneAdjustmentsField
 * ZoneAdjustmentsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.link.ZoneAdjustmentsLink
 * ZoneAdjustmentsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#PROPOSAL_START_DATE
 * PROPOSAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#PROPOSAL_VERSION
 * PROPOSAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#BUF_PRPSL_ZONE_ADJMT_FCTR_START_DATE
 * BUF_PRPSL_ZONE_ADJMT_FCTR_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#BUF_PRPSL_ZONE_ADJMT_FCTR_END_DATE
 * BUF_PRPSL_ZONE_ADJMT_FCTR_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#RED_ZONE_ADJUSTMENT_FACTOR
 * RED_ZONE_ADJUSTMENT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#YELLOW_ZONE_ADJUSTMENT_FACTOR
 * YELLOW_ZONE_ADJUSTMENT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#GREEN_ZONE_ADJUSTMENT_FACTOR
 * GREEN_ZONE_ADJUSTMENT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments#TO_PROPOSAL_HDR
 * TO_PROPOSAL_HDR}</li>
 * </ul>
 *
 */
public interface ZoneAdjustmentsSelectable extends EntitySelectable<ZoneAdjustments>
{

}
