/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.field.BusinessAreaTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.link.BusinessAreaTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.selectable.BusinessAreaTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Area Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusinessAreaTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessAreaText extends VdmEntity<BusinessAreaText>
{

    /**
     * Selector for all available fields of BusinessAreaText.
     *
     */
    public final static BusinessAreaTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @Key
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static BusinessAreaTextField<String> BUSINESS_AREA = new BusinessAreaTextField<String>("BusinessArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusinessAreaTextField<String> LANGUAGE = new BusinessAreaTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @return Business Area Description
     */
    @SerializedName( "BusinessAreaName" )
    @JsonProperty( "BusinessAreaName" )
    @Nullable
    @ODataField( odataName = "BusinessAreaName" )
    private String businessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaName</b> field to query operations.
     *
     */
    public final static BusinessAreaTextField<String> BUSINESS_AREA_NAME =
        new BusinessAreaTextField<String>("BusinessAreaName");
    /**
     * Navigation property <b>to_BusinessArea</b> for <b>BusinessAreaText</b> to single <b>BusinessArea</b>.
     *
     */
    @SerializedName( "to_BusinessArea" )
    @JsonProperty( "to_BusinessArea" )
    @ODataField( odataName = "to_BusinessArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessArea toBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessArea</b> navigation property to query operations.
     *
     */
    public final static BusinessAreaTextOneToOneLink<BusinessArea> TO_BUSINESS_AREA =
        new BusinessAreaTextOneToOneLink<BusinessArea>("to_BusinessArea");

    @Nonnull
    @Override
    public Class<BusinessAreaText> getType()
    {
        return BusinessAreaText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @param businessAreaName
     *            Business Area Description
     */
    public void setBusinessAreaName( @Nullable final String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusinessAreaText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessArea", getBusinessArea());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessArea", getBusinessArea());
        values.put("Language", getLanguage());
        values.put("BusinessAreaName", getBusinessAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessArea") ) {
                final Object value = (values).remove("to_BusinessArea");
                if( value instanceof Map ) {
                    if( toBusinessArea == null ) {
                        toBusinessArea = new BusinessArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessAreaTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessAreaTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessAreaTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessAreaTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessAreaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessArea != null ) {
            (values).put("to_BusinessArea", toBusinessArea);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessArea</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BusinessArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessArea</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessArea fetchBusinessArea()
    {
        return fetchFieldAsSingle("to_BusinessArea", BusinessArea.class);
    }

    /**
     * Retrieval of associated <b>BusinessArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BusinessArea</b>.
     * <p>
     * If the navigation property <b>to_BusinessArea</b> of a queried <b>BusinessAreaText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessArea getBusinessAreaOrFetch()
    {
        if( toBusinessArea == null ) {
            toBusinessArea = fetchBusinessArea();
        }
        return toBusinessArea;
    }

    /**
     * Retrieval of associated <b>BusinessArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BusinessArea</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessAreaText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessArea</b> is already loaded, the result will
     *         contain the <b>BusinessArea</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessArea> getBusinessAreaIfPresent()
    {
        return Option.of(toBusinessArea);
    }

    /**
     * Overwrites the associated <b>BusinessArea</b> entity for the loaded navigation property <b>to_BusinessArea</b>.
     *
     * @param value
     *            New <b>BusinessArea</b> entity.
     */
    public void setBusinessArea( final BusinessArea value )
    {
        toBusinessArea = value;
    }

    /**
     * Helper class to allow for fluent creation of BusinessAreaText instances.
     *
     */
    public final static class BusinessAreaTextBuilder
    {

        private BusinessArea toBusinessArea;
        private String businessArea = null;

        private BusinessAreaText.BusinessAreaTextBuilder toBusinessArea( final BusinessArea value )
        {
            toBusinessArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessArea</b> for <b>BusinessAreaText</b> to single <b>BusinessArea</b>.
         *
         * @param value
         *            The BusinessArea to build this BusinessAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessAreaText.BusinessAreaTextBuilder businessArea( final BusinessArea value )
        {
            return toBusinessArea(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>BusinessArea</b>
         * </p>
         *
         * @param value
         *            The businessArea to build this BusinessAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessAreaText.BusinessAreaTextBuilder businessArea( final String value )
        {
            businessArea = value;
            return this;
        }

    }

}
