/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessAreaServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessAreaService BusinessAreaService}.
 *
 */
public class DefaultBusinessAreaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessAreaServiceBatch, BusinessAreaServiceBatchChangeSet>
    implements
    BusinessAreaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessAreaService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessAreaServiceBatchChangeSet(
        @Nonnull final DefaultBusinessAreaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessAreaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessAreaServiceBatchChangeSet getThis()
    {
        return this;
    }

}
