/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessArea BusinessArea}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.field.BusinessAreaField
 * BusinessAreaField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.link.BusinessAreaLink
 * BusinessAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessArea#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessArea#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessAreaSelectable extends EntitySelectable<BusinessArea>
{

}
