/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BehqueuedataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link.BehqueuedataLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link.BehqueuedataOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BehqueuedataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Event Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_BehqueuedataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Behqueuedata extends VdmEntity<Behqueuedata>
{

    /**
     * Selector for all available fields of Behqueuedata.
     *
     */
    public final static BehqueuedataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEvent</b>
     * </p>
     *
     * @return GUID of an Event
     */
    @Key
    @SerializedName( "BusinessEvent" )
    @JsonProperty( "BusinessEvent" )
    @Nullable
    @ODataField( odataName = "BusinessEvent" )
    private UUID businessEvent;
    /**
     * Use with available fluent helpers to apply the <b>BusinessEvent</b> field to query operations.
     *
     */
    public final static BehqueuedataField<UUID> BUSINESS_EVENT = new BehqueuedataField<UUID>("BusinessEvent");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @return SAP Object Task Type Name
     */
    @SerializedName( "SAPObjectTaskTypeName" )
    @JsonProperty( "SAPObjectTaskTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskTypeName" )
    private String sAPObjectTaskTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskTypeName</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_OBJECT_TASK_TYPE_NAME =
        new BehqueuedataField<String>("SAPObjectTaskTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @return SAP Object Type Name
     */
    @SerializedName( "SAPObjectTypeName" )
    @JsonProperty( "SAPObjectTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTypeName" )
    private String sAPObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTypeName</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_OBJECT_TYPE_NAME =
        new BehqueuedataField<String>("SAPObjectTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_OBJECT_TYPE = new BehqueuedataField<String>("SAPObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @return Subscriber ID
     */
    @SerializedName( "BusEventSubscriberCode" )
    @JsonProperty( "BusEventSubscriberCode" )
    @Nullable
    @ODataField( odataName = "BusEventSubscriberCode" )
    private String busEventSubscriberCode;
    /**
     * Use with available fluent helpers to apply the <b>BusEventSubscriberCode</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> BUS_EVENT_SUBSCRIBER_CODE =
        new BehqueuedataField<String>("BusEventSubscriberCode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @return Business Event Type
     */
    @SerializedName( "SAPObjectTaskCode" )
    @JsonProperty( "SAPObjectTaskCode" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskCode" )
    private String sAPObjectTaskCode;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskCode</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_OBJECT_TASK_CODE =
        new BehqueuedataField<String>("SAPObjectTaskCode");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEventSubscriberName</b>
     * </p>
     *
     * @return Subscriber Name
     */
    @SerializedName( "BusinessEventSubscriberName" )
    @JsonProperty( "BusinessEventSubscriberName" )
    @Nullable
    @ODataField( odataName = "BusinessEventSubscriberName" )
    private String businessEventSubscriberName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessEventSubscriberName</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> BUSINESS_EVENT_SUBSCRIBER_NAME =
        new BehqueuedataField<String>("BusinessEventSubscriberName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey1</b>
     * </p>
     *
     * @return Business Object Key 1
     */
    @SerializedName( "SAPBusinessObjectKey1" )
    @JsonProperty( "SAPBusinessObjectKey1" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey1" )
    private String sAPBusinessObjectKey1;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey1</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY1 =
        new BehqueuedataField<String>("SAPBusinessObjectKey1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey2</b>
     * </p>
     *
     * @return Business Object Key 2
     */
    @SerializedName( "SAPBusinessObjectKey2" )
    @JsonProperty( "SAPBusinessObjectKey2" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey2" )
    private String sAPBusinessObjectKey2;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey2</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY2 =
        new BehqueuedataField<String>("SAPBusinessObjectKey2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey3</b>
     * </p>
     *
     * @return Business Object Key 3
     */
    @SerializedName( "SAPBusinessObjectKey3" )
    @JsonProperty( "SAPBusinessObjectKey3" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey3" )
    private String sAPBusinessObjectKey3;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey3</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY3 =
        new BehqueuedataField<String>("SAPBusinessObjectKey3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey4</b>
     * </p>
     *
     * @return Business Object Key 4
     */
    @SerializedName( "SAPBusinessObjectKey4" )
    @JsonProperty( "SAPBusinessObjectKey4" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey4" )
    private String sAPBusinessObjectKey4;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey4</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY4 =
        new BehqueuedataField<String>("SAPBusinessObjectKey4");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey5</b>
     * </p>
     *
     * @return Business Object Key 5
     */
    @SerializedName( "SAPBusinessObjectKey5" )
    @JsonProperty( "SAPBusinessObjectKey5" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey5" )
    private String sAPBusinessObjectKey5;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey5</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY5 =
        new BehqueuedataField<String>("SAPBusinessObjectKey5");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey6</b>
     * </p>
     *
     * @return Business Object Key 6
     */
    @SerializedName( "SAPBusinessObjectKey6" )
    @JsonProperty( "SAPBusinessObjectKey6" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey6" )
    private String sAPBusinessObjectKey6;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey6</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY6 =
        new BehqueuedataField<String>("SAPBusinessObjectKey6");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey7</b>
     * </p>
     *
     * @return Business Object Key 7
     */
    @SerializedName( "SAPBusinessObjectKey7" )
    @JsonProperty( "SAPBusinessObjectKey7" )
    @Nullable
    @ODataField( odataName = "SAPBusinessObjectKey7" )
    private String sAPBusinessObjectKey7;
    /**
     * Use with available fluent helpers to apply the <b>SAPBusinessObjectKey7</b> field to query operations.
     *
     */
    public final static BehqueuedataField<String> SAP_BUSINESS_OBJECT_KEY7 =
        new BehqueuedataField<String>("SAPBusinessObjectKey7");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @return Subscription priority
     */
    @SerializedName( "BusEventPriority" )
    @JsonProperty( "BusEventPriority" )
    @Nullable
    @ODataField( odataName = "BusEventPriority" )
    private Short busEventPriority;
    /**
     * Use with available fluent helpers to apply the <b>BusEventPriority</b> field to query operations.
     *
     */
    public final static BehqueuedataField<Short> BUS_EVENT_PRIORITY = new BehqueuedataField<Short>("BusEventPriority");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "CreationUTCDateTime" )
    @JsonProperty( "CreationUTCDateTime" )
    @Nullable
    @ODataField( odataName = "CreationUTCDateTime" )
    private BigDecimal creationUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationUTCDateTime</b> field to query operations.
     *
     */
    public final static BehqueuedataField<BigDecimal> CREATION_UTC_DATE_TIME =
        new BehqueuedataField<BigDecimal>("CreationUTCDateTime");
    /**
     * Navigation property <b>to_BusObjects</b> for <b>Behqueuedata</b> to multiple <b>BusObjects</b>.
     *
     */
    @SerializedName( "to_BusObjects" )
    @JsonProperty( "to_BusObjects" )
    @ODataField( odataName = "to_BusObjects" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusObjects> toBusObjects;
    /**
     * Navigation property <b>to_Keys</b> for <b>Behqueuedata</b> to single <b>BusinessObjectKeys</b>.
     *
     */
    @SerializedName( "to_Keys" )
    @JsonProperty( "to_Keys" )
    @ODataField( odataName = "to_Keys" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessObjectKeys toKeys;
    /**
     * Use with available fluent helpers to apply the <b>to_BusObjects</b> navigation property to query operations.
     *
     */
    public final static BehqueuedataLink<BusObjects> TO_BUS_OBJECTS = new BehqueuedataLink<BusObjects>("to_BusObjects");
    /**
     * Use with available fluent helpers to apply the <b>to_Keys</b> navigation property to query operations.
     *
     */
    public final static BehqueuedataOneToOneLink<BusinessObjectKeys> TO_KEYS =
        new BehqueuedataOneToOneLink<BusinessObjectKeys>("to_Keys");

    @Nonnull
    @Override
    public Class<Behqueuedata> getType()
    {
        return Behqueuedata.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEvent</b>
     * </p>
     *
     * @param businessEvent
     *            GUID of an Event
     */
    public void setBusinessEvent( @Nullable final UUID businessEvent )
    {
        rememberChangedField("BusinessEvent", this.businessEvent);
        this.businessEvent = businessEvent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @param sAPObjectTaskTypeName
     *            SAP Object Task Type Name
     */
    public void setSAPObjectTaskTypeName( @Nullable final String sAPObjectTaskTypeName )
    {
        rememberChangedField("SAPObjectTaskTypeName", this.sAPObjectTaskTypeName);
        this.sAPObjectTaskTypeName = sAPObjectTaskTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @param sAPObjectTypeName
     *            SAP Object Type Name
     */
    public void setSAPObjectTypeName( @Nullable final String sAPObjectTypeName )
    {
        rememberChangedField("SAPObjectTypeName", this.sAPObjectTypeName);
        this.sAPObjectTypeName = sAPObjectTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @param busEventSubscriberCode
     *            Subscriber ID
     */
    public void setBusEventSubscriberCode( @Nullable final String busEventSubscriberCode )
    {
        rememberChangedField("BusEventSubscriberCode", this.busEventSubscriberCode);
        this.busEventSubscriberCode = busEventSubscriberCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @param sAPObjectTaskCode
     *            Business Event Type
     */
    public void setSAPObjectTaskCode( @Nullable final String sAPObjectTaskCode )
    {
        rememberChangedField("SAPObjectTaskCode", this.sAPObjectTaskCode);
        this.sAPObjectTaskCode = sAPObjectTaskCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEventSubscriberName</b>
     * </p>
     *
     * @param businessEventSubscriberName
     *            Subscriber Name
     */
    public void setBusinessEventSubscriberName( @Nullable final String businessEventSubscriberName )
    {
        rememberChangedField("BusinessEventSubscriberName", this.businessEventSubscriberName);
        this.businessEventSubscriberName = businessEventSubscriberName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey1</b>
     * </p>
     *
     * @param sAPBusinessObjectKey1
     *            Business Object Key 1
     */
    public void setSAPBusinessObjectKey1( @Nullable final String sAPBusinessObjectKey1 )
    {
        rememberChangedField("SAPBusinessObjectKey1", this.sAPBusinessObjectKey1);
        this.sAPBusinessObjectKey1 = sAPBusinessObjectKey1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey2</b>
     * </p>
     *
     * @param sAPBusinessObjectKey2
     *            Business Object Key 2
     */
    public void setSAPBusinessObjectKey2( @Nullable final String sAPBusinessObjectKey2 )
    {
        rememberChangedField("SAPBusinessObjectKey2", this.sAPBusinessObjectKey2);
        this.sAPBusinessObjectKey2 = sAPBusinessObjectKey2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey3</b>
     * </p>
     *
     * @param sAPBusinessObjectKey3
     *            Business Object Key 3
     */
    public void setSAPBusinessObjectKey3( @Nullable final String sAPBusinessObjectKey3 )
    {
        rememberChangedField("SAPBusinessObjectKey3", this.sAPBusinessObjectKey3);
        this.sAPBusinessObjectKey3 = sAPBusinessObjectKey3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey4</b>
     * </p>
     *
     * @param sAPBusinessObjectKey4
     *            Business Object Key 4
     */
    public void setSAPBusinessObjectKey4( @Nullable final String sAPBusinessObjectKey4 )
    {
        rememberChangedField("SAPBusinessObjectKey4", this.sAPBusinessObjectKey4);
        this.sAPBusinessObjectKey4 = sAPBusinessObjectKey4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey5</b>
     * </p>
     *
     * @param sAPBusinessObjectKey5
     *            Business Object Key 5
     */
    public void setSAPBusinessObjectKey5( @Nullable final String sAPBusinessObjectKey5 )
    {
        rememberChangedField("SAPBusinessObjectKey5", this.sAPBusinessObjectKey5);
        this.sAPBusinessObjectKey5 = sAPBusinessObjectKey5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey6</b>
     * </p>
     *
     * @param sAPBusinessObjectKey6
     *            Business Object Key 6
     */
    public void setSAPBusinessObjectKey6( @Nullable final String sAPBusinessObjectKey6 )
    {
        rememberChangedField("SAPBusinessObjectKey6", this.sAPBusinessObjectKey6);
        this.sAPBusinessObjectKey6 = sAPBusinessObjectKey6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SAPBusinessObjectKey7</b>
     * </p>
     *
     * @param sAPBusinessObjectKey7
     *            Business Object Key 7
     */
    public void setSAPBusinessObjectKey7( @Nullable final String sAPBusinessObjectKey7 )
    {
        rememberChangedField("SAPBusinessObjectKey7", this.sAPBusinessObjectKey7);
        this.sAPBusinessObjectKey7 = sAPBusinessObjectKey7;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @param busEventPriority
     *            Subscription priority
     */
    public void setBusEventPriority( @Nullable final Short busEventPriority )
    {
        rememberChangedField("BusEventPriority", this.busEventPriority);
        this.busEventPriority = busEventPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     *
     * @param creationUTCDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationUTCDateTime( @Nullable final BigDecimal creationUTCDateTime )
    {
        rememberChangedField("CreationUTCDateTime", this.creationUTCDateTime);
        this.creationUTCDateTime = creationUTCDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_Behqueuedata";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessEvent", getBusinessEvent());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessEvent", getBusinessEvent());
        values.put("SAPObjectTaskTypeName", getSAPObjectTaskTypeName());
        values.put("SAPObjectTypeName", getSAPObjectTypeName());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("BusEventSubscriberCode", getBusEventSubscriberCode());
        values.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        values.put("BusinessEventSubscriberName", getBusinessEventSubscriberName());
        values.put("SAPBusinessObjectKey1", getSAPBusinessObjectKey1());
        values.put("SAPBusinessObjectKey2", getSAPBusinessObjectKey2());
        values.put("SAPBusinessObjectKey3", getSAPBusinessObjectKey3());
        values.put("SAPBusinessObjectKey4", getSAPBusinessObjectKey4());
        values.put("SAPBusinessObjectKey5", getSAPBusinessObjectKey5());
        values.put("SAPBusinessObjectKey6", getSAPBusinessObjectKey6());
        values.put("SAPBusinessObjectKey7", getSAPBusinessObjectKey7());
        values.put("BusEventPriority", getBusEventPriority());
        values.put("CreationUTCDateTime", getCreationUTCDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessEvent") ) {
                final Object value = values.remove("BusinessEvent");
                if( (value == null) || (!value.equals(getBusinessEvent())) ) {
                    setBusinessEvent(((UUID) value));
                }
            }
            if( values.containsKey("SAPObjectTaskTypeName") ) {
                final Object value = values.remove("SAPObjectTaskTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTaskTypeName())) ) {
                    setSAPObjectTaskTypeName(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTypeName") ) {
                final Object value = values.remove("SAPObjectTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTypeName())) ) {
                    setSAPObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("BusEventSubscriberCode") ) {
                final Object value = values.remove("BusEventSubscriberCode");
                if( (value == null) || (!value.equals(getBusEventSubscriberCode())) ) {
                    setBusEventSubscriberCode(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskCode") ) {
                final Object value = values.remove("SAPObjectTaskCode");
                if( (value == null) || (!value.equals(getSAPObjectTaskCode())) ) {
                    setSAPObjectTaskCode(((String) value));
                }
            }
            if( values.containsKey("BusinessEventSubscriberName") ) {
                final Object value = values.remove("BusinessEventSubscriberName");
                if( (value == null) || (!value.equals(getBusinessEventSubscriberName())) ) {
                    setBusinessEventSubscriberName(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey1") ) {
                final Object value = values.remove("SAPBusinessObjectKey1");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey1())) ) {
                    setSAPBusinessObjectKey1(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey2") ) {
                final Object value = values.remove("SAPBusinessObjectKey2");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey2())) ) {
                    setSAPBusinessObjectKey2(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey3") ) {
                final Object value = values.remove("SAPBusinessObjectKey3");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey3())) ) {
                    setSAPBusinessObjectKey3(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey4") ) {
                final Object value = values.remove("SAPBusinessObjectKey4");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey4())) ) {
                    setSAPBusinessObjectKey4(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey5") ) {
                final Object value = values.remove("SAPBusinessObjectKey5");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey5())) ) {
                    setSAPBusinessObjectKey5(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey6") ) {
                final Object value = values.remove("SAPBusinessObjectKey6");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey6())) ) {
                    setSAPBusinessObjectKey6(((String) value));
                }
            }
            if( values.containsKey("SAPBusinessObjectKey7") ) {
                final Object value = values.remove("SAPBusinessObjectKey7");
                if( (value == null) || (!value.equals(getSAPBusinessObjectKey7())) ) {
                    setSAPBusinessObjectKey7(((String) value));
                }
            }
            if( values.containsKey("BusEventPriority") ) {
                final Object value = values.remove("BusEventPriority");
                if( (value == null) || (!value.equals(getBusEventPriority())) ) {
                    setBusEventPriority(((Short) value));
                }
            }
            if( values.containsKey("CreationUTCDateTime") ) {
                final Object value = values.remove("CreationUTCDateTime");
                if( (value == null) || (!value.equals(getCreationUTCDateTime())) ) {
                    setCreationUTCDateTime(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusObjects") ) {
                final Object value = (values).remove("to_BusObjects");
                if( value instanceof Iterable ) {
                    if( toBusObjects == null ) {
                        toBusObjects = Lists.newArrayList();
                    } else {
                        toBusObjects = Lists.newArrayList(toBusObjects);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusObjects entity;
                        if( toBusObjects.size() > i ) {
                            entity = toBusObjects.get(i);
                        } else {
                            entity = new BusObjects();
                            toBusObjects.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Keys") ) {
                final Object value = (values).remove("to_Keys");
                if( value instanceof Map ) {
                    if( toKeys == null ) {
                        toKeys = new BusinessObjectKeys();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toKeys.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BehqueuedataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BehqueuedataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BehqueuedataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BehqueuedataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusObjects != null ) {
            (values).put("to_BusObjects", toBusObjects);
        }
        if( toKeys != null ) {
            (values).put("to_Keys", toKeys);
        }
        return values;
    }

    /**
     * Fetches the <b>BusObjects</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BusObjects</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusObjects</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusObjects> fetchBusObjects()
    {
        return fetchFieldAsList("to_BusObjects", BusObjects.class);
    }

    /**
     * Retrieval of associated <b>BusObjects</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BusObjects</b>.
     * <p>
     * If the navigation property <b>to_BusObjects</b> of a queried <b>Behqueuedata</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusObjects</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusObjects> getBusObjectsOrFetch()
    {
        if( toBusObjects == null ) {
            toBusObjects = fetchBusObjects();
        }
        return toBusObjects;
    }

    /**
     * Retrieval of associated <b>BusObjects</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BusObjects</b>.
     * <p>
     * If the navigation property for an entity <b>Behqueuedata</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusObjects</b> is already loaded, the result will
     *         contain the <b>BusObjects</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusObjects>> getBusObjectsIfPresent()
    {
        return Option.of(toBusObjects);
    }

    /**
     * Overwrites the list of associated <b>BusObjects</b> entities for the loaded navigation property
     * <b>to_BusObjects</b>.
     * <p>
     * If the navigation property <b>to_BusObjects</b> of a queried <b>Behqueuedata</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusObjects</b> entities.
     */
    public void setBusObjects( @Nonnull final List<BusObjects> value )
    {
        if( toBusObjects == null ) {
            toBusObjects = Lists.newArrayList();
        }
        toBusObjects.clear();
        toBusObjects.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusObjects</b> entities. This corresponds to the OData navigation
     * property <b>to_BusObjects</b>.
     * <p>
     * If the navigation property <b>to_BusObjects</b> of a queried <b>Behqueuedata</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusObjects</b> entities.
     */
    public void addBusObjects( BusObjects... entity )
    {
        if( toBusObjects == null ) {
            toBusObjects = Lists.newArrayList();
        }
        toBusObjects.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessObjectKeys</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Keys</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessObjectKeys</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessObjectKeys fetchKeys()
    {
        return fetchFieldAsSingle("to_Keys", BusinessObjectKeys.class);
    }

    /**
     * Retrieval of associated <b>BusinessObjectKeys</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Keys</b>.
     * <p>
     * If the navigation property <b>to_Keys</b> of a queried <b>Behqueuedata</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessObjectKeys</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessObjectKeys getKeysOrFetch()
    {
        if( toKeys == null ) {
            toKeys = fetchKeys();
        }
        return toKeys;
    }

    /**
     * Retrieval of associated <b>BusinessObjectKeys</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Keys</b>.
     * <p>
     * If the navigation property for an entity <b>Behqueuedata</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Keys</b> is already loaded, the result will contain the
     *         <b>BusinessObjectKeys</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BusinessObjectKeys> getKeysIfPresent()
    {
        return Option.of(toKeys);
    }

    /**
     * Overwrites the associated <b>BusinessObjectKeys</b> entity for the loaded navigation property <b>to_Keys</b>.
     *
     * @param value
     *            New <b>BusinessObjectKeys</b> entity.
     */
    public void setKeys( final BusinessObjectKeys value )
    {
        toKeys = value;
    }

    /**
     * Helper class to allow for fluent creation of Behqueuedata instances.
     *
     */
    public final static class BehqueuedataBuilder
    {

        private List<BusObjects> toBusObjects = Lists.newArrayList();
        private BusinessObjectKeys toKeys;

        private Behqueuedata.BehqueuedataBuilder toBusObjects( final List<BusObjects> value )
        {
            toBusObjects.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusObjects</b> for <b>Behqueuedata</b> to multiple <b>BusObjects</b>.
         *
         * @param value
         *            The BusObjectss to build this Behqueuedata with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Behqueuedata.BehqueuedataBuilder busObjects( BusObjects... value )
        {
            return toBusObjects(Lists.newArrayList(value));
        }

        private Behqueuedata.BehqueuedataBuilder toKeys( final BusinessObjectKeys value )
        {
            toKeys = value;
            return this;
        }

        /**
         * Navigation property <b>to_Keys</b> for <b>Behqueuedata</b> to single <b>BusinessObjectKeys</b>.
         *
         * @param value
         *            The BusinessObjectKeys to build this Behqueuedata with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Behqueuedata.BehqueuedataBuilder keys( final BusinessObjectKeys value )
        {
            return toKeys(value);
        }

    }

}
