/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BusObjectsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BusObjectsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SAP Object Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_BusObjectsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusObjects extends VdmEntity<BusObjects>
{

    /**
     * Selector for all available fields of BusObjects.
     *
     */
    public final static BusObjectsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static BusObjectsField<String> SAP_OBJECT_TYPE = new BusObjectsField<String>("SAPObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @return SAP Object Type Name
     */
    @Key
    @SerializedName( "SAPObjectTypeName" )
    @JsonProperty( "SAPObjectTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTypeName" )
    private String sAPObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTypeName</b> field to query operations.
     *
     */
    public final static BusObjectsField<String> SAP_OBJECT_TYPE_NAME = new BusObjectsField<String>("SAPObjectTypeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @return Business Event Type
     */
    @Key
    @SerializedName( "SAPObjectTaskCode" )
    @JsonProperty( "SAPObjectTaskCode" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskCode" )
    private String sAPObjectTaskCode;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskCode</b> field to query operations.
     *
     */
    public final static BusObjectsField<String> SAP_OBJECT_TASK_CODE = new BusObjectsField<String>("SAPObjectTaskCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @return SAP Object Task Type Name
     */
    @Key
    @SerializedName( "SAPObjectTaskTypeName" )
    @JsonProperty( "SAPObjectTaskTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskTypeName" )
    private String sAPObjectTaskTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskTypeName</b> field to query operations.
     *
     */
    public final static BusObjectsField<String> SAP_OBJECT_TASK_TYPE_NAME =
        new BusObjectsField<String>("SAPObjectTaskTypeName");

    @Nonnull
    @Override
    public Class<BusObjects> getType()
    {
        return BusObjects.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @param sAPObjectTypeName
     *            SAP Object Type Name
     */
    public void setSAPObjectTypeName( @Nullable final String sAPObjectTypeName )
    {
        rememberChangedField("SAPObjectTypeName", this.sAPObjectTypeName);
        this.sAPObjectTypeName = sAPObjectTypeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @param sAPObjectTaskCode
     *            Business Event Type
     */
    public void setSAPObjectTaskCode( @Nullable final String sAPObjectTaskCode )
    {
        rememberChangedField("SAPObjectTaskCode", this.sAPObjectTaskCode);
        this.sAPObjectTaskCode = sAPObjectTaskCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @param sAPObjectTaskTypeName
     *            SAP Object Task Type Name
     */
    public void setSAPObjectTaskTypeName( @Nullable final String sAPObjectTaskTypeName )
    {
        rememberChangedField("SAPObjectTaskTypeName", this.sAPObjectTaskTypeName);
        this.sAPObjectTaskTypeName = sAPObjectTaskTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_BusObjects";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SAPObjectType", getSAPObjectType());
        result.put("SAPObjectTypeName", getSAPObjectTypeName());
        result.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        result.put("SAPObjectTaskTypeName", getSAPObjectTaskTypeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectTypeName", getSAPObjectTypeName());
        values.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        values.put("SAPObjectTaskTypeName", getSAPObjectTaskTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTypeName") ) {
                final Object value = values.remove("SAPObjectTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTypeName())) ) {
                    setSAPObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskCode") ) {
                final Object value = values.remove("SAPObjectTaskCode");
                if( (value == null) || (!value.equals(getSAPObjectTaskCode())) ) {
                    setSAPObjectTaskCode(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskTypeName") ) {
                final Object value = values.remove("SAPObjectTaskTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTaskTypeName())) ) {
                    setSAPObjectTaskTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusObjectsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusObjectsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusObjectsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusObjectsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService.DEFAULT_SERVICE_PATH);
    }

}
