/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BusObjectsSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects BusObjects} entity using key
 * fields. This fluent helper allows methods which modify the underlying query to be called before executing the query
 * itself.
 *
 */
public class BusObjectsByKeyFluentHelper
    extends
    FluentHelperByKey<BusObjectsByKeyFluentHelper, BusObjects, BusObjectsSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects BusObjects} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusObjects}
     * @param sAPObjectTaskCode
     *            Business Event Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusObjects}
     * @param sAPObjectTypeName
     *            SAP Object Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 80
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param sAPObjectTaskTypeName
     *            SAP Object Task Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 80
     *            </p>
     */
    public BusObjectsByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sAPObjectType,
        final String sAPObjectTypeName,
        final String sAPObjectTaskCode,
        final String sAPObjectTaskTypeName )
    {
        super(servicePath, entityCollection);
        this.key.put("SAPObjectType", sAPObjectType);
        this.key.put("SAPObjectTypeName", sAPObjectTypeName);
        this.key.put("SAPObjectTaskCode", sAPObjectTaskCode);
        this.key.put("SAPObjectTaskTypeName", sAPObjectTaskTypeName);
    }

    @Override
    @Nonnull
    protected Class<BusObjects> getEntityClass()
    {
        return BusObjects.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
