/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BusinessObjectKeysField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BusinessObjectKeysSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SAP Object Type Keys
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_BusinessObjectKeysType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessObjectKeys extends VdmEntity<BusinessObjectKeys>
{

    /**
     * Selector for all available fields of BusinessObjectKeys.
     *
     */
    public final static BusinessObjectKeysSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> SAP_OBJECT_TYPE =
        new BusinessObjectKeysField<String>("SAPObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName1</b>
     * </p>
     *
     * @return Business Object Key Name 1
     */
    @SerializedName( "KeyFieldName1" )
    @JsonProperty( "KeyFieldName1" )
    @Nullable
    @ODataField( odataName = "KeyFieldName1" )
    private String keyFieldName1;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName1</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME1 =
        new BusinessObjectKeysField<String>("KeyFieldName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName2</b>
     * </p>
     *
     * @return Business Object Key Name 2
     */
    @SerializedName( "KeyFieldName2" )
    @JsonProperty( "KeyFieldName2" )
    @Nullable
    @ODataField( odataName = "KeyFieldName2" )
    private String keyFieldName2;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName2</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME2 =
        new BusinessObjectKeysField<String>("KeyFieldName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName3</b>
     * </p>
     *
     * @return Business Object Key Name 3
     */
    @SerializedName( "KeyFieldName3" )
    @JsonProperty( "KeyFieldName3" )
    @Nullable
    @ODataField( odataName = "KeyFieldName3" )
    private String keyFieldName3;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName3</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME3 =
        new BusinessObjectKeysField<String>("KeyFieldName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName4</b>
     * </p>
     *
     * @return Business Object Key Name 4
     */
    @SerializedName( "KeyFieldName4" )
    @JsonProperty( "KeyFieldName4" )
    @Nullable
    @ODataField( odataName = "KeyFieldName4" )
    private String keyFieldName4;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName4</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME4 =
        new BusinessObjectKeysField<String>("KeyFieldName4");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName5</b>
     * </p>
     *
     * @return Business Object Key Name 5
     */
    @SerializedName( "KeyFieldName5" )
    @JsonProperty( "KeyFieldName5" )
    @Nullable
    @ODataField( odataName = "KeyFieldName5" )
    private String keyFieldName5;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName5</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME5 =
        new BusinessObjectKeysField<String>("KeyFieldName5");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName6</b>
     * </p>
     *
     * @return Business Object Key Name 6
     */
    @SerializedName( "KeyFieldName6" )
    @JsonProperty( "KeyFieldName6" )
    @Nullable
    @ODataField( odataName = "KeyFieldName6" )
    private String keyFieldName6;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName6</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME6 =
        new BusinessObjectKeysField<String>("KeyFieldName6");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName7</b>
     * </p>
     *
     * @return Business Object Key Name 7
     */
    @SerializedName( "KeyFieldName7" )
    @JsonProperty( "KeyFieldName7" )
    @Nullable
    @ODataField( odataName = "KeyFieldName7" )
    private String keyFieldName7;
    /**
     * Use with available fluent helpers to apply the <b>KeyFieldName7</b> field to query operations.
     *
     */
    public final static BusinessObjectKeysField<String> KEY_FIELD_NAME7 =
        new BusinessObjectKeysField<String>("KeyFieldName7");

    @Nonnull
    @Override
    public Class<BusinessObjectKeys> getType()
    {
        return BusinessObjectKeys.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName1</b>
     * </p>
     *
     * @param keyFieldName1
     *            Business Object Key Name 1
     */
    public void setKeyFieldName1( @Nullable final String keyFieldName1 )
    {
        rememberChangedField("KeyFieldName1", this.keyFieldName1);
        this.keyFieldName1 = keyFieldName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName2</b>
     * </p>
     *
     * @param keyFieldName2
     *            Business Object Key Name 2
     */
    public void setKeyFieldName2( @Nullable final String keyFieldName2 )
    {
        rememberChangedField("KeyFieldName2", this.keyFieldName2);
        this.keyFieldName2 = keyFieldName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName3</b>
     * </p>
     *
     * @param keyFieldName3
     *            Business Object Key Name 3
     */
    public void setKeyFieldName3( @Nullable final String keyFieldName3 )
    {
        rememberChangedField("KeyFieldName3", this.keyFieldName3);
        this.keyFieldName3 = keyFieldName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName4</b>
     * </p>
     *
     * @param keyFieldName4
     *            Business Object Key Name 4
     */
    public void setKeyFieldName4( @Nullable final String keyFieldName4 )
    {
        rememberChangedField("KeyFieldName4", this.keyFieldName4);
        this.keyFieldName4 = keyFieldName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName5</b>
     * </p>
     *
     * @param keyFieldName5
     *            Business Object Key Name 5
     */
    public void setKeyFieldName5( @Nullable final String keyFieldName5 )
    {
        rememberChangedField("KeyFieldName5", this.keyFieldName5);
        this.keyFieldName5 = keyFieldName5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName6</b>
     * </p>
     *
     * @param keyFieldName6
     *            Business Object Key Name 6
     */
    public void setKeyFieldName6( @Nullable final String keyFieldName6 )
    {
        rememberChangedField("KeyFieldName6", this.keyFieldName6);
        this.keyFieldName6 = keyFieldName6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>KeyFieldName7</b>
     * </p>
     *
     * @param keyFieldName7
     *            Business Object Key Name 7
     */
    public void setKeyFieldName7( @Nullable final String keyFieldName7 )
    {
        rememberChangedField("KeyFieldName7", this.keyFieldName7);
        this.keyFieldName7 = keyFieldName7;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_BusinessObjectKeys";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SAPObjectType", getSAPObjectType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SAPObjectType", getSAPObjectType());
        values.put("KeyFieldName1", getKeyFieldName1());
        values.put("KeyFieldName2", getKeyFieldName2());
        values.put("KeyFieldName3", getKeyFieldName3());
        values.put("KeyFieldName4", getKeyFieldName4());
        values.put("KeyFieldName5", getKeyFieldName5());
        values.put("KeyFieldName6", getKeyFieldName6());
        values.put("KeyFieldName7", getKeyFieldName7());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName1") ) {
                final Object value = values.remove("KeyFieldName1");
                if( (value == null) || (!value.equals(getKeyFieldName1())) ) {
                    setKeyFieldName1(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName2") ) {
                final Object value = values.remove("KeyFieldName2");
                if( (value == null) || (!value.equals(getKeyFieldName2())) ) {
                    setKeyFieldName2(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName3") ) {
                final Object value = values.remove("KeyFieldName3");
                if( (value == null) || (!value.equals(getKeyFieldName3())) ) {
                    setKeyFieldName3(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName4") ) {
                final Object value = values.remove("KeyFieldName4");
                if( (value == null) || (!value.equals(getKeyFieldName4())) ) {
                    setKeyFieldName4(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName5") ) {
                final Object value = values.remove("KeyFieldName5");
                if( (value == null) || (!value.equals(getKeyFieldName5())) ) {
                    setKeyFieldName5(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName6") ) {
                final Object value = values.remove("KeyFieldName6");
                if( (value == null) || (!value.equals(getKeyFieldName6())) ) {
                    setKeyFieldName6(((String) value));
                }
            }
            if( values.containsKey("KeyFieldName7") ) {
                final Object value = values.remove("KeyFieldName7");
                if( (value == null) || (!value.equals(getKeyFieldName7())) ) {
                    setKeyFieldName7(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessObjectKeysField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessObjectKeysField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessObjectKeysField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessObjectKeysField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService.DEFAULT_SERVICE_PATH);
    }

}
